/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.network.model;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.network.model.BlockedCookieWithReason;
import org.openqa.selenium.devtools.network.model.Headers;
import org.openqa.selenium.devtools.network.model.RequestId;
import org.openqa.selenium.json.JsonInput;

@Beta
public class RequestWillBeSentExtraInfo {
    private final RequestId requestId;
    private final List<BlockedCookieWithReason> blockedCookies;
    private final Headers headers;

    public RequestWillBeSentExtraInfo(RequestId requestId, List<BlockedCookieWithReason> blockedCookies, Headers headers) {
        this.requestId = Objects.requireNonNull(requestId, "requestId is required");
        this.blockedCookies = Objects.requireNonNull(blockedCookies, "blockedCookies is required");
        this.headers = Objects.requireNonNull(headers, "headers is required");
    }

    public RequestId getRequestId() {
        return this.requestId;
    }

    public List<BlockedCookieWithReason> getBlockedCookies() {
        return this.blockedCookies;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    private static RequestWillBeSentExtraInfo fromJson(JsonInput input) {
        RequestId requestId = null;
        List blockedCookies = null;
        Headers headers = null;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "requestId": {
                    requestId = (RequestId)input.read(RequestId.class);
                    continue block10;
                }
                case "blockedCookies": {
                    blockedCookies = (List)input.read(new TypeToken<List<BlockedCookieWithReason>>(){}.getType());
                    continue block10;
                }
                case "headers": {
                    headers = (Headers)((Object)input.read(Headers.class));
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new RequestWillBeSentExtraInfo(requestId, blockedCookies, headers);
    }
}

