/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.network.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum BlockedReason {
    OTHER("other"),
    CSP("csp"),
    MIXED_CONTENT("mixed-content"),
    ORIGIN("origin"),
    INSPECTOR("inspector"),
    SUBRESOURCE_FILTER("subresource-filter"),
    CONTENT_TYPE("content-type"),
    COLLAPSED_BY_CLIENT("collapsed-by-client");

    private String value;

    private BlockedReason(String value) {
        this.value = value;
    }

    public static BlockedReason fromString(String s) {
        return Arrays.stream(BlockedReason.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within BlockedReason "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static BlockedReason fromJson(JsonInput input) {
        return BlockedReason.fromString(input.nextString());
    }
}

