/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.indexeddb.model;

import com.google.common.reflect.TypeToken;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public class KeyPath {
    private final Type type;
    private final String string;
    private final List<String> array;

    public KeyPath(Type type, String string, List<String> array) {
        this.type = Objects.requireNonNull(type, "type is required");
        this.string = string;
        this.array = array;
    }

    public Type getType() {
        return this.type;
    }

    public String getString() {
        return this.string;
    }

    public List<String> getArray() {
        return this.array;
    }

    private static KeyPath fromJson(JsonInput input) {
        Type type = null;
        String string = null;
        List array = null;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "type": {
                    type = Type.fromString(input.nextString());
                    continue block10;
                }
                case "string": {
                    string = input.nextString();
                    continue block10;
                }
                case "array": {
                    array = (List)input.read(new TypeToken<List<String>>(){}.getType());
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new KeyPath(type, string, array);
    }

    public static enum Type {
        NULL("null"),
        STRING("string"),
        ARRAY("array");

        private String value;

        private Type(String value) {
            this.value = value;
        }

        public static Type fromString(String s) {
            return Arrays.stream(Type.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within Type "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Type fromJson(JsonInput input) {
            return Type.fromString(input.nextString());
        }
    }
}

