/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.domsnapshot.model;

import java.util.Objects;
import org.openqa.selenium.devtools.domsnapshot.model.LayoutTreeSnapshot;
import org.openqa.selenium.devtools.domsnapshot.model.NodeTreeSnapshot;
import org.openqa.selenium.devtools.domsnapshot.model.StringIndex;
import org.openqa.selenium.devtools.domsnapshot.model.TextBoxSnapshot;
import org.openqa.selenium.json.JsonInput;

public class DocumentSnapshot {
    private final StringIndex documentURL;
    private final StringIndex baseURL;
    private final StringIndex contentLanguage;
    private final StringIndex encodingName;
    private final StringIndex publicId;
    private final StringIndex systemId;
    private final StringIndex frameId;
    private final NodeTreeSnapshot nodes;
    private final LayoutTreeSnapshot layout;
    private final TextBoxSnapshot textBoxes;
    private final Number scrollOffsetX;
    private final Number scrollOffsetY;

    public DocumentSnapshot(StringIndex documentURL, StringIndex baseURL, StringIndex contentLanguage, StringIndex encodingName, StringIndex publicId, StringIndex systemId, StringIndex frameId, NodeTreeSnapshot nodes, LayoutTreeSnapshot layout, TextBoxSnapshot textBoxes, Number scrollOffsetX, Number scrollOffsetY) {
        this.documentURL = Objects.requireNonNull(documentURL, "documentURL is required");
        this.baseURL = Objects.requireNonNull(baseURL, "baseURL is required");
        this.contentLanguage = Objects.requireNonNull(contentLanguage, "contentLanguage is required");
        this.encodingName = Objects.requireNonNull(encodingName, "encodingName is required");
        this.publicId = Objects.requireNonNull(publicId, "publicId is required");
        this.systemId = Objects.requireNonNull(systemId, "systemId is required");
        this.frameId = Objects.requireNonNull(frameId, "frameId is required");
        this.nodes = Objects.requireNonNull(nodes, "nodes is required");
        this.layout = Objects.requireNonNull(layout, "layout is required");
        this.textBoxes = Objects.requireNonNull(textBoxes, "textBoxes is required");
        this.scrollOffsetX = scrollOffsetX;
        this.scrollOffsetY = scrollOffsetY;
    }

    public StringIndex getDocumentURL() {
        return this.documentURL;
    }

    public StringIndex getBaseURL() {
        return this.baseURL;
    }

    public StringIndex getContentLanguage() {
        return this.contentLanguage;
    }

    public StringIndex getEncodingName() {
        return this.encodingName;
    }

    public StringIndex getPublicId() {
        return this.publicId;
    }

    public StringIndex getSystemId() {
        return this.systemId;
    }

    public StringIndex getFrameId() {
        return this.frameId;
    }

    public NodeTreeSnapshot getNodes() {
        return this.nodes;
    }

    public LayoutTreeSnapshot getLayout() {
        return this.layout;
    }

    public TextBoxSnapshot getTextBoxes() {
        return this.textBoxes;
    }

    public Number getScrollOffsetX() {
        return this.scrollOffsetX;
    }

    public Number getScrollOffsetY() {
        return this.scrollOffsetY;
    }

    private static DocumentSnapshot fromJson(JsonInput input) {
        StringIndex documentURL = null;
        StringIndex baseURL = null;
        StringIndex contentLanguage = null;
        StringIndex encodingName = null;
        StringIndex publicId = null;
        StringIndex systemId = null;
        StringIndex frameId = null;
        NodeTreeSnapshot nodes = null;
        LayoutTreeSnapshot layout = null;
        TextBoxSnapshot textBoxes = null;
        Number scrollOffsetX = null;
        Number scrollOffsetY = null;
        input.beginObject();
        block28: while (input.hasNext()) {
            switch (input.nextName()) {
                case "documentURL": {
                    documentURL = (StringIndex)input.read(StringIndex.class);
                    continue block28;
                }
                case "baseURL": {
                    baseURL = (StringIndex)input.read(StringIndex.class);
                    continue block28;
                }
                case "contentLanguage": {
                    contentLanguage = (StringIndex)input.read(StringIndex.class);
                    continue block28;
                }
                case "encodingName": {
                    encodingName = (StringIndex)input.read(StringIndex.class);
                    continue block28;
                }
                case "publicId": {
                    publicId = (StringIndex)input.read(StringIndex.class);
                    continue block28;
                }
                case "systemId": {
                    systemId = (StringIndex)input.read(StringIndex.class);
                    continue block28;
                }
                case "frameId": {
                    frameId = (StringIndex)input.read(StringIndex.class);
                    continue block28;
                }
                case "nodes": {
                    nodes = (NodeTreeSnapshot)input.read(NodeTreeSnapshot.class);
                    continue block28;
                }
                case "layout": {
                    layout = (LayoutTreeSnapshot)input.read(LayoutTreeSnapshot.class);
                    continue block28;
                }
                case "textBoxes": {
                    textBoxes = (TextBoxSnapshot)input.read(TextBoxSnapshot.class);
                    continue block28;
                }
                case "scrollOffsetX": {
                    scrollOffsetX = input.nextNumber();
                    continue block28;
                }
                case "scrollOffsetY": {
                    scrollOffsetY = input.nextNumber();
                    continue block28;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new DocumentSnapshot(documentURL, baseURL, contentLanguage, encodingName, publicId, systemId, frameId, nodes, layout, textBoxes, scrollOffsetX, scrollOffsetY);
    }
}

