/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.css.model;

import java.util.Objects;
import org.openqa.selenium.devtools.css.model.SourceRange;
import org.openqa.selenium.json.JsonInput;

public class MediaQueryExpression {
    private final Number value;
    private final String unit;
    private final String feature;
    private final SourceRange valueRange;
    private final Number computedLength;

    public MediaQueryExpression(Number value, String unit, String feature, SourceRange valueRange, Number computedLength) {
        this.value = Objects.requireNonNull(value, "value is required");
        this.unit = Objects.requireNonNull(unit, "unit is required");
        this.feature = Objects.requireNonNull(feature, "feature is required");
        this.valueRange = valueRange;
        this.computedLength = computedLength;
    }

    public Number getValue() {
        return this.value;
    }

    public String getUnit() {
        return this.unit;
    }

    public String getFeature() {
        return this.feature;
    }

    public SourceRange getValueRange() {
        return this.valueRange;
    }

    public Number getComputedLength() {
        return this.computedLength;
    }

    private static MediaQueryExpression fromJson(JsonInput input) {
        Number value = null;
        String unit = null;
        String feature = null;
        SourceRange valueRange = null;
        Number computedLength = null;
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "value": {
                    value = input.nextNumber();
                    continue block14;
                }
                case "unit": {
                    unit = input.nextString();
                    continue block14;
                }
                case "feature": {
                    feature = input.nextString();
                    continue block14;
                }
                case "valueRange": {
                    valueRange = (SourceRange)input.read(SourceRange.class);
                    continue block14;
                }
                case "computedLength": {
                    computedLength = input.nextNumber();
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new MediaQueryExpression(value, unit, feature, valueRange, computedLength);
    }
}

