/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.css.model;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.devtools.css.model.CSSMedia;
import org.openqa.selenium.devtools.css.model.CSSStyle;
import org.openqa.selenium.devtools.css.model.SelectorList;
import org.openqa.selenium.devtools.css.model.StyleSheetId;
import org.openqa.selenium.devtools.css.model.StyleSheetOrigin;
import org.openqa.selenium.json.JsonInput;

public class CSSRule {
    private final StyleSheetId styleSheetId;
    private final SelectorList selectorList;
    private final StyleSheetOrigin origin;
    private final CSSStyle style;
    private final List<CSSMedia> media;

    public CSSRule(StyleSheetId styleSheetId, SelectorList selectorList, StyleSheetOrigin origin, CSSStyle style, List<CSSMedia> media) {
        this.styleSheetId = styleSheetId;
        this.selectorList = Objects.requireNonNull(selectorList, "selectorList is required");
        this.origin = Objects.requireNonNull(origin, "origin is required");
        this.style = Objects.requireNonNull(style, "style is required");
        this.media = media;
    }

    public StyleSheetId getStyleSheetId() {
        return this.styleSheetId;
    }

    public SelectorList getSelectorList() {
        return this.selectorList;
    }

    public StyleSheetOrigin getOrigin() {
        return this.origin;
    }

    public CSSStyle getStyle() {
        return this.style;
    }

    public List<CSSMedia> getMedia() {
        return this.media;
    }

    private static CSSRule fromJson(JsonInput input) {
        StyleSheetId styleSheetId = null;
        SelectorList selectorList = null;
        StyleSheetOrigin origin = null;
        CSSStyle style = null;
        List media = null;
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "styleSheetId": {
                    styleSheetId = (StyleSheetId)input.read(StyleSheetId.class);
                    continue block14;
                }
                case "selectorList": {
                    selectorList = (SelectorList)input.read(SelectorList.class);
                    continue block14;
                }
                case "origin": {
                    origin = (StyleSheetOrigin)((Object)input.read(StyleSheetOrigin.class));
                    continue block14;
                }
                case "style": {
                    style = (CSSStyle)input.read(CSSStyle.class);
                    continue block14;
                }
                case "media": {
                    media = (List)input.read(new TypeToken<List<CSSMedia>>(){}.getType());
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CSSRule(styleSheetId, selectorList, origin, style, media);
    }
}

