/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.css;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.css.model.CSSComputedStyleProperty;
import org.openqa.selenium.devtools.css.model.CSSKeyframesRule;
import org.openqa.selenium.devtools.css.model.CSSMedia;
import org.openqa.selenium.devtools.css.model.CSSRule;
import org.openqa.selenium.devtools.css.model.CSSStyle;
import org.openqa.selenium.devtools.css.model.CSSStyleSheetHeader;
import org.openqa.selenium.devtools.css.model.FontFace;
import org.openqa.selenium.devtools.css.model.InheritedStyleEntry;
import org.openqa.selenium.devtools.css.model.PlatformFontUsage;
import org.openqa.selenium.devtools.css.model.PseudoElementMatches;
import org.openqa.selenium.devtools.css.model.RuleMatch;
import org.openqa.selenium.devtools.css.model.RuleUsage;
import org.openqa.selenium.devtools.css.model.SelectorList;
import org.openqa.selenium.devtools.css.model.SourceRange;
import org.openqa.selenium.devtools.css.model.StyleDeclarationEdit;
import org.openqa.selenium.devtools.css.model.StyleSheetId;
import org.openqa.selenium.devtools.css.model.Value;
import org.openqa.selenium.devtools.dom.model.NodeId;
import org.openqa.selenium.devtools.page.model.FrameId;
import org.openqa.selenium.json.JsonInput;

@Beta
public class CSS {
    public static Command<CSSRule> addRule(StyleSheetId styleSheetId, String ruleText, SourceRange location) {
        Objects.requireNonNull(styleSheetId, "styleSheetId is required");
        Objects.requireNonNull(ruleText, "ruleText is required");
        Objects.requireNonNull(location, "location is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"styleSheetId", (Object)styleSheetId);
        params.put((Object)"ruleText", (Object)ruleText);
        params.put((Object)"location", (Object)location);
        return new Command<CSSRule>("CSS.addRule", (Map<String, Object>)params.build(), ConverterFunctions.map("rule", CSSRule.class));
    }

    public static Command<List<String>> collectClassNames(StyleSheetId styleSheetId) {
        Objects.requireNonNull(styleSheetId, "styleSheetId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"styleSheetId", (Object)styleSheetId);
        return new Command<List<String>>("CSS.collectClassNames", (Map<String, Object>)params.build(), ConverterFunctions.map("classNames", new TypeToken<List<String>>(){}.getType()));
    }

    public static Command<StyleSheetId> createStyleSheet(FrameId frameId) {
        Objects.requireNonNull(frameId, "frameId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"frameId", (Object)frameId);
        return new Command<StyleSheetId>("CSS.createStyleSheet", (Map<String, Object>)params.build(), ConverterFunctions.map("styleSheetId", StyleSheetId.class));
    }

    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("CSS.disable", (Map<String, Object>)params.build());
    }

    public static Command<Void> enable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("CSS.enable", (Map<String, Object>)params.build());
    }

    public static Command<Void> forcePseudoState(NodeId nodeId, List<String> forcedPseudoClasses) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(forcedPseudoClasses, "forcedPseudoClasses is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        params.put((Object)"forcedPseudoClasses", forcedPseudoClasses);
        return new Command<Void>("CSS.forcePseudoState", (Map<String, Object>)params.build());
    }

    public static Command<GetBackgroundColorsResponse> getBackgroundColors(NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        return new Command<GetBackgroundColorsResponse>("CSS.getBackgroundColors", (Map<String, Object>)params.build(), input -> (GetBackgroundColorsResponse)input.read(GetBackgroundColorsResponse.class));
    }

    public static Command<List<CSSComputedStyleProperty>> getComputedStyleForNode(NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        return new Command<List<CSSComputedStyleProperty>>("CSS.getComputedStyleForNode", (Map<String, Object>)params.build(), ConverterFunctions.map("computedStyle", new TypeToken<List<CSSComputedStyleProperty>>(){}.getType()));
    }

    public static Command<GetInlineStylesForNodeResponse> getInlineStylesForNode(NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        return new Command<GetInlineStylesForNodeResponse>("CSS.getInlineStylesForNode", (Map<String, Object>)params.build(), input -> (GetInlineStylesForNodeResponse)input.read(GetInlineStylesForNodeResponse.class));
    }

    public static Command<GetMatchedStylesForNodeResponse> getMatchedStylesForNode(NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        return new Command<GetMatchedStylesForNodeResponse>("CSS.getMatchedStylesForNode", (Map<String, Object>)params.build(), input -> (GetMatchedStylesForNodeResponse)input.read(GetMatchedStylesForNodeResponse.class));
    }

    public static Command<List<CSSMedia>> getMediaQueries() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<List<CSSMedia>>("CSS.getMediaQueries", (Map<String, Object>)params.build(), ConverterFunctions.map("medias", new TypeToken<List<CSSMedia>>(){}.getType()));
    }

    public static Command<List<PlatformFontUsage>> getPlatformFontsForNode(NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        return new Command<List<PlatformFontUsage>>("CSS.getPlatformFontsForNode", (Map<String, Object>)params.build(), ConverterFunctions.map("fonts", new TypeToken<List<PlatformFontUsage>>(){}.getType()));
    }

    public static Command<String> getStyleSheetText(StyleSheetId styleSheetId) {
        Objects.requireNonNull(styleSheetId, "styleSheetId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"styleSheetId", (Object)styleSheetId);
        return new Command<String>("CSS.getStyleSheetText", (Map<String, Object>)params.build(), ConverterFunctions.map("text", String.class));
    }

    public static Command<Void> setEffectivePropertyValueForNode(NodeId nodeId, String propertyName, String value) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(propertyName, "propertyName is required");
        Objects.requireNonNull(value, "value is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        params.put((Object)"propertyName", (Object)propertyName);
        params.put((Object)"value", (Object)value);
        return new Command<Void>("CSS.setEffectivePropertyValueForNode", (Map<String, Object>)params.build());
    }

    public static Command<Value> setKeyframeKey(StyleSheetId styleSheetId, SourceRange range, String keyText) {
        Objects.requireNonNull(styleSheetId, "styleSheetId is required");
        Objects.requireNonNull(range, "range is required");
        Objects.requireNonNull(keyText, "keyText is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"styleSheetId", (Object)styleSheetId);
        params.put((Object)"range", (Object)range);
        params.put((Object)"keyText", (Object)keyText);
        return new Command<Value>("CSS.setKeyframeKey", (Map<String, Object>)params.build(), ConverterFunctions.map("keyText", Value.class));
    }

    public static Command<CSSMedia> setMediaText(StyleSheetId styleSheetId, SourceRange range, String text) {
        Objects.requireNonNull(styleSheetId, "styleSheetId is required");
        Objects.requireNonNull(range, "range is required");
        Objects.requireNonNull(text, "text is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"styleSheetId", (Object)styleSheetId);
        params.put((Object)"range", (Object)range);
        params.put((Object)"text", (Object)text);
        return new Command<CSSMedia>("CSS.setMediaText", (Map<String, Object>)params.build(), ConverterFunctions.map("media", CSSMedia.class));
    }

    public static Command<SelectorList> setRuleSelector(StyleSheetId styleSheetId, SourceRange range, String selector) {
        Objects.requireNonNull(styleSheetId, "styleSheetId is required");
        Objects.requireNonNull(range, "range is required");
        Objects.requireNonNull(selector, "selector is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"styleSheetId", (Object)styleSheetId);
        params.put((Object)"range", (Object)range);
        params.put((Object)"selector", (Object)selector);
        return new Command<SelectorList>("CSS.setRuleSelector", (Map<String, Object>)params.build(), ConverterFunctions.map("selectorList", SelectorList.class));
    }

    public static Command<String> setStyleSheetText(StyleSheetId styleSheetId, String text) {
        Objects.requireNonNull(styleSheetId, "styleSheetId is required");
        Objects.requireNonNull(text, "text is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"styleSheetId", (Object)styleSheetId);
        params.put((Object)"text", (Object)text);
        return new Command<String>("CSS.setStyleSheetText", (Map<String, Object>)params.build(), ConverterFunctions.map("sourceMapURL", String.class));
    }

    public static Command<List<CSSStyle>> setStyleTexts(List<StyleDeclarationEdit> edits) {
        Objects.requireNonNull(edits, "edits is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"edits", edits);
        return new Command<List<CSSStyle>>("CSS.setStyleTexts", (Map<String, Object>)params.build(), ConverterFunctions.map("styles", new TypeToken<List<CSSStyle>>(){}.getType()));
    }

    public static Command<Void> startRuleUsageTracking() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("CSS.startRuleUsageTracking", (Map<String, Object>)params.build());
    }

    public static Command<List<RuleUsage>> stopRuleUsageTracking() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<List<RuleUsage>>("CSS.stopRuleUsageTracking", (Map<String, Object>)params.build(), ConverterFunctions.map("ruleUsage", new TypeToken<List<RuleUsage>>(){}.getType()));
    }

    public static Command<List<RuleUsage>> takeCoverageDelta() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<List<RuleUsage>>("CSS.takeCoverageDelta", (Map<String, Object>)params.build(), ConverterFunctions.map("coverage", new TypeToken<List<RuleUsage>>(){}.getType()));
    }

    public static Event<FontFace> fontsUpdated() {
        return new Event<FontFace>("CSS.fontsUpdated", ConverterFunctions.map("font", FontFace.class));
    }

    public static Event<Void> mediaQueryResultChanged() {
        return new Event<Void>("CSS.mediaQueryResultChanged", input -> null);
    }

    public static Event<CSSStyleSheetHeader> styleSheetAdded() {
        return new Event<CSSStyleSheetHeader>("CSS.styleSheetAdded", ConverterFunctions.map("header", CSSStyleSheetHeader.class));
    }

    public static Event<StyleSheetId> styleSheetChanged() {
        return new Event<StyleSheetId>("CSS.styleSheetChanged", ConverterFunctions.map("styleSheetId", StyleSheetId.class));
    }

    public static Event<StyleSheetId> styleSheetRemoved() {
        return new Event<StyleSheetId>("CSS.styleSheetRemoved", ConverterFunctions.map("styleSheetId", StyleSheetId.class));
    }

    public static class GetMatchedStylesForNodeResponse {
        private final CSSStyle inlineStyle;
        private final CSSStyle attributesStyle;
        private final List<RuleMatch> matchedCSSRules;
        private final List<PseudoElementMatches> pseudoElements;
        private final List<InheritedStyleEntry> inherited;
        private final List<CSSKeyframesRule> cssKeyframesRules;

        public GetMatchedStylesForNodeResponse(CSSStyle inlineStyle, CSSStyle attributesStyle, List<RuleMatch> matchedCSSRules, List<PseudoElementMatches> pseudoElements, List<InheritedStyleEntry> inherited, List<CSSKeyframesRule> cssKeyframesRules) {
            this.inlineStyle = Objects.requireNonNull(inlineStyle, "inlineStyle is required");
            this.attributesStyle = Objects.requireNonNull(attributesStyle, "attributesStyle is required");
            this.matchedCSSRules = Objects.requireNonNull(matchedCSSRules, "matchedCSSRules is required");
            this.pseudoElements = Objects.requireNonNull(pseudoElements, "pseudoElements is required");
            this.inherited = Objects.requireNonNull(inherited, "inherited is required");
            this.cssKeyframesRules = Objects.requireNonNull(cssKeyframesRules, "cssKeyframesRules is required");
        }

        public CSSStyle getInlineStyle() {
            return this.inlineStyle;
        }

        public CSSStyle getAttributesStyle() {
            return this.attributesStyle;
        }

        public List<RuleMatch> getMatchedCSSRules() {
            return this.matchedCSSRules;
        }

        public List<PseudoElementMatches> getPseudoElements() {
            return this.pseudoElements;
        }

        public List<InheritedStyleEntry> getInherited() {
            return this.inherited;
        }

        public List<CSSKeyframesRule> getCssKeyframesRules() {
            return this.cssKeyframesRules;
        }

        private static GetMatchedStylesForNodeResponse fromJson(JsonInput input) {
            CSSStyle inlineStyle = null;
            CSSStyle attributesStyle = null;
            List matchedCSSRules = null;
            List pseudoElements = null;
            List inherited = null;
            List cssKeyframesRules = null;
            input.beginObject();
            block16: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "inlineStyle": {
                        inlineStyle = (CSSStyle)input.read(CSSStyle.class);
                        continue block16;
                    }
                    case "attributesStyle": {
                        attributesStyle = (CSSStyle)input.read(CSSStyle.class);
                        continue block16;
                    }
                    case "matchedCSSRules": {
                        matchedCSSRules = (List)input.read(new TypeToken<List<RuleMatch>>(){}.getType());
                        continue block16;
                    }
                    case "pseudoElements": {
                        pseudoElements = (List)input.read(new TypeToken<List<PseudoElementMatches>>(){}.getType());
                        continue block16;
                    }
                    case "inherited": {
                        inherited = (List)input.read(new TypeToken<List<InheritedStyleEntry>>(){}.getType());
                        continue block16;
                    }
                    case "cssKeyframesRules": {
                        cssKeyframesRules = (List)input.read(new TypeToken<List<CSSKeyframesRule>>(){}.getType());
                        continue block16;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetMatchedStylesForNodeResponse(inlineStyle, attributesStyle, matchedCSSRules, pseudoElements, inherited, cssKeyframesRules);
        }
    }

    public static class GetInlineStylesForNodeResponse {
        private final CSSStyle inlineStyle;
        private final CSSStyle attributesStyle;

        public GetInlineStylesForNodeResponse(CSSStyle inlineStyle, CSSStyle attributesStyle) {
            this.inlineStyle = Objects.requireNonNull(inlineStyle, "inlineStyle is required");
            this.attributesStyle = Objects.requireNonNull(attributesStyle, "attributesStyle is required");
        }

        public CSSStyle getInlineStyle() {
            return this.inlineStyle;
        }

        public CSSStyle getAttributesStyle() {
            return this.attributesStyle;
        }

        private static GetInlineStylesForNodeResponse fromJson(JsonInput input) {
            CSSStyle inlineStyle = null;
            CSSStyle attributesStyle = null;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "inlineStyle": {
                        inlineStyle = (CSSStyle)input.read(CSSStyle.class);
                        continue block8;
                    }
                    case "attributesStyle": {
                        attributesStyle = (CSSStyle)input.read(CSSStyle.class);
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetInlineStylesForNodeResponse(inlineStyle, attributesStyle);
        }
    }

    public static class GetBackgroundColorsResponse {
        private final List<String> backgroundColors;
        private final String computedFontSize;
        private final String computedFontWeight;

        public GetBackgroundColorsResponse(List<String> backgroundColors, String computedFontSize, String computedFontWeight) {
            this.backgroundColors = Objects.requireNonNull(backgroundColors, "backgroundColors is required");
            this.computedFontSize = Objects.requireNonNull(computedFontSize, "computedFontSize is required");
            this.computedFontWeight = Objects.requireNonNull(computedFontWeight, "computedFontWeight is required");
        }

        public List<String> getBackgroundColors() {
            return this.backgroundColors;
        }

        public String getComputedFontSize() {
            return this.computedFontSize;
        }

        public String getComputedFontWeight() {
            return this.computedFontWeight;
        }

        private static GetBackgroundColorsResponse fromJson(JsonInput input) {
            List backgroundColors = null;
            String computedFontSize = null;
            String computedFontWeight = null;
            input.beginObject();
            block10: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "backgroundColors": {
                        backgroundColors = (List)input.read(new TypeToken<List<String>>(){}.getType());
                        continue block10;
                    }
                    case "computedFontSize": {
                        computedFontSize = input.nextString();
                        continue block10;
                    }
                    case "computedFontWeight": {
                        computedFontWeight = input.nextString();
                        continue block10;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetBackgroundColorsResponse(backgroundColors, computedFontSize, computedFontWeight);
        }
    }
}

