/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.browser.model;

import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@Beta
public class PermissionDescriptor {
    private final String name;
    private final Boolean sysex;
    private final Boolean userVisibleOnly;
    private final String type;

    public PermissionDescriptor(String name, Boolean sysex, Boolean userVisibleOnly, String type) {
        this.name = Objects.requireNonNull(name, "name is required");
        this.sysex = sysex;
        this.userVisibleOnly = userVisibleOnly;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public Boolean getSysex() {
        return this.sysex;
    }

    public Boolean getUserVisibleOnly() {
        return this.userVisibleOnly;
    }

    public String getType() {
        return this.type;
    }

    private static PermissionDescriptor fromJson(JsonInput input) {
        String name = null;
        Boolean sysex = null;
        Boolean userVisibleOnly = null;
        String type = null;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "name": {
                    name = input.nextString();
                    continue block12;
                }
                case "sysex": {
                    sysex = input.nextBoolean();
                    continue block12;
                }
                case "userVisibleOnly": {
                    userVisibleOnly = input.nextBoolean();
                    continue block12;
                }
                case "type": {
                    type = input.nextString();
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new PermissionDescriptor(name, sysex, userVisibleOnly, type);
    }
}

