/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.browser.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.browser.model.WindowState;
import org.openqa.selenium.json.JsonInput;

@Beta
public class Bounds {
    private final Integer left;
    private final Integer top;
    private final Integer width;
    private final Integer height;
    private final WindowState windowState;

    public Bounds(Integer left, Integer top, Integer width, Integer height, WindowState windowState) {
        this.left = left;
        this.top = top;
        this.width = width;
        this.height = height;
        this.windowState = windowState;
    }

    public Integer getLeft() {
        return this.left;
    }

    public Integer getTop() {
        return this.top;
    }

    public Integer getWidth() {
        return this.width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public WindowState getWindowState() {
        return this.windowState;
    }

    private static Bounds fromJson(JsonInput input) {
        Integer left = null;
        Integer top = null;
        Integer width = null;
        Integer height = null;
        WindowState windowState = null;
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "left": {
                    left = input.nextNumber().intValue();
                    continue block14;
                }
                case "top": {
                    top = input.nextNumber().intValue();
                    continue block14;
                }
                case "width": {
                    width = input.nextNumber().intValue();
                    continue block14;
                }
                case "height": {
                    height = input.nextNumber().intValue();
                    continue block14;
                }
                case "windowState": {
                    windowState = (WindowState)((Object)input.read(WindowState.class));
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new Bounds(left, top, width, height, windowState);
    }
}

