/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.openqa.selenium.json.JsonInput;

public class Command<X> {
    private final String method;
    private final Map<String, Object> params;
    private final Function<JsonInput, X> mapper;
    private final boolean sendsResponse;

    public Command(String method, Map<String, Object> params) {
        this(method, params, (Type)((Object)Void.class));
    }

    public Command(String method, Map<String, Object> params, Type typeOfX) {
        this(method, params, (JsonInput input) -> input.read(typeOfX));
        Objects.requireNonNull(typeOfX, "Type to convert to must be set.");
    }

    public Command(String method, Map<String, Object> params, Function<JsonInput, X> mapper) {
        this(method, params, mapper, true);
    }

    private Command(String method, Map<String, Object> params, Function<JsonInput, X> mapper, boolean sendsResponse) {
        this.method = Objects.requireNonNull(method, "Method name must be set.");
        this.params = ImmutableMap.copyOf(Objects.requireNonNull(params, "Command parameters must be set."));
        this.mapper = Objects.requireNonNull(mapper, "Mapper for result must be set.");
        this.sendsResponse = sendsResponse;
    }

    public String getMethod() {
        return this.method;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    Function<JsonInput, X> getMapper() {
        return this.mapper;
    }

    public boolean getSendsResponse() {
        return this.sendsResponse;
    }

    public Command<X> doesNotSendResponse() {
        return new Command<X>(this.method, this.params, this.mapper, false);
    }
}

