package org.openqa.selenium.devtools.v89.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Details for a request that has been blocked with the BLOCKED_BY_RESPONSE
 * code. Currently only used for COEP/COOP, but may be extended to include
 * some CSP errors in the future.
 */
public class SharedArrayBufferTransferIssueDetails {

    private final org.openqa.selenium.devtools.v89.audits.model.SourceCodeLocation sourceCodeLocation;

    private final java.lang.Boolean isWarning;

    public SharedArrayBufferTransferIssueDetails(org.openqa.selenium.devtools.v89.audits.model.SourceCodeLocation sourceCodeLocation, java.lang.Boolean isWarning) {
        this.sourceCodeLocation = java.util.Objects.requireNonNull(sourceCodeLocation, "sourceCodeLocation is required");
        this.isWarning = java.util.Objects.requireNonNull(isWarning, "isWarning is required");
    }

    public org.openqa.selenium.devtools.v89.audits.model.SourceCodeLocation getSourceCodeLocation() {
        return sourceCodeLocation;
    }

    public java.lang.Boolean getIsWarning() {
        return isWarning;
    }

    private static SharedArrayBufferTransferIssueDetails fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v89.audits.model.SourceCodeLocation sourceCodeLocation = null;
        java.lang.Boolean isWarning = false;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "sourceCodeLocation":
                    sourceCodeLocation = input.read(org.openqa.selenium.devtools.v89.audits.model.SourceCodeLocation.class);
                    break;
                case "isWarning":
                    isWarning = input.nextBoolean();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new SharedArrayBufferTransferIssueDetails(sourceCodeLocation, isWarning);
    }
}
