package org.openqa.selenium.devtools.v88.runtime.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Call frames for assertions or error messages.
 */
public class StackTrace {

    private final java.util.Optional<java.lang.String> description;

    private final java.util.List<org.openqa.selenium.devtools.v88.runtime.model.CallFrame> callFrames;

    private final java.util.Optional<org.openqa.selenium.devtools.v88.runtime.model.StackTrace> parent;

    private final java.util.Optional<org.openqa.selenium.devtools.v88.runtime.model.StackTraceId> parentId;

    public StackTrace(java.util.Optional<java.lang.String> description, java.util.List<org.openqa.selenium.devtools.v88.runtime.model.CallFrame> callFrames, java.util.Optional<org.openqa.selenium.devtools.v88.runtime.model.StackTrace> parent, java.util.Optional<org.openqa.selenium.devtools.v88.runtime.model.StackTraceId> parentId) {
        this.description = description;
        this.callFrames = java.util.Objects.requireNonNull(callFrames, "callFrames is required");
        this.parent = parent;
        this.parentId = parentId;
    }

    /**
     * String label of this stack trace. For async traces this may be a name of the function that
     * initiated the async call.
     */
    public java.util.Optional<java.lang.String> getDescription() {
        return description;
    }

    /**
     * JavaScript function name.
     */
    public java.util.List<org.openqa.selenium.devtools.v88.runtime.model.CallFrame> getCallFrames() {
        return callFrames;
    }

    /**
     * Asynchronous JavaScript stack trace that preceded this stack, if available.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v88.runtime.model.StackTrace> getParent() {
        return parent;
    }

    /**
     * Asynchronous JavaScript stack trace that preceded this stack, if available.
     */
    @Beta()
    public java.util.Optional<org.openqa.selenium.devtools.v88.runtime.model.StackTraceId> getParentId() {
        return parentId;
    }

    private static StackTrace fromJson(JsonInput input) {
        java.util.Optional<java.lang.String> description = java.util.Optional.empty();
        java.util.List<org.openqa.selenium.devtools.v88.runtime.model.CallFrame> callFrames = null;
        java.util.Optional<org.openqa.selenium.devtools.v88.runtime.model.StackTrace> parent = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v88.runtime.model.StackTraceId> parentId = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "description":
                    description = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "callFrames":
                    callFrames = input.read(new com.google.common.reflect.TypeToken<java.util.List<org.openqa.selenium.devtools.v88.runtime.model.CallFrame>>() {
                    }.getType());
                    break;
                case "parent":
                    parent = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v88.runtime.model.StackTrace.class));
                    break;
                case "parentId":
                    parentId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v88.runtime.model.StackTraceId.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new StackTrace(description, callFrames, parent, parentId);
    }
}
