package org.openqa.selenium.devtools.v88.fetch.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public class RequestPattern {

    private final java.util.Optional<java.lang.String> urlPattern;

    private final java.util.Optional<org.openqa.selenium.devtools.v88.network.model.ResourceType> resourceType;

    private final java.util.Optional<org.openqa.selenium.devtools.v88.fetch.model.RequestStage> requestStage;

    public RequestPattern(java.util.Optional<java.lang.String> urlPattern, java.util.Optional<org.openqa.selenium.devtools.v88.network.model.ResourceType> resourceType, java.util.Optional<org.openqa.selenium.devtools.v88.fetch.model.RequestStage> requestStage) {
        this.urlPattern = urlPattern;
        this.resourceType = resourceType;
        this.requestStage = requestStage;
    }

    /**
     * Wildcards ('*' -> zero or more, '?' -> exactly one) are allowed. Escape character is
     * backslash. Omitting is equivalent to "*".
     */
    public java.util.Optional<java.lang.String> getUrlPattern() {
        return urlPattern;
    }

    /**
     * If set, only requests for matching resource types will be intercepted.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v88.network.model.ResourceType> getResourceType() {
        return resourceType;
    }

    /**
     * Stage at wich to begin intercepting requests. Default is Request.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v88.fetch.model.RequestStage> getRequestStage() {
        return requestStage;
    }

    private static RequestPattern fromJson(JsonInput input) {
        java.util.Optional<java.lang.String> urlPattern = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v88.network.model.ResourceType> resourceType = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v88.fetch.model.RequestStage> requestStage = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "urlPattern":
                    urlPattern = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "resourceType":
                    resourceType = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v88.network.model.ResourceType.class));
                    break;
                case "requestStage":
                    requestStage = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v88.fetch.model.RequestStage.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new RequestPattern(urlPattern, resourceType, requestStage);
    }
}
