package org.openqa.selenium.devtools.v85.security.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Security state information about the page.
 */
@org.openqa.selenium.Beta()
public class VisibleSecurityState {

    private final org.openqa.selenium.devtools.v85.security.model.SecurityState securityState;

    private final java.util.Optional<org.openqa.selenium.devtools.v85.security.model.CertificateSecurityState> certificateSecurityState;

    private final java.util.Optional<org.openqa.selenium.devtools.v85.security.model.SafetyTipInfo> safetyTipInfo;

    private final java.util.List<java.lang.String> securityStateIssueIds;

    public VisibleSecurityState(org.openqa.selenium.devtools.v85.security.model.SecurityState securityState, java.util.Optional<org.openqa.selenium.devtools.v85.security.model.CertificateSecurityState> certificateSecurityState, java.util.Optional<org.openqa.selenium.devtools.v85.security.model.SafetyTipInfo> safetyTipInfo, java.util.List<java.lang.String> securityStateIssueIds) {
        this.securityState = java.util.Objects.requireNonNull(securityState, "securityState is required");
        this.certificateSecurityState = certificateSecurityState;
        this.safetyTipInfo = safetyTipInfo;
        this.securityStateIssueIds = java.util.Objects.requireNonNull(securityStateIssueIds, "securityStateIssueIds is required");
    }

    /**
     * The security level of the page.
     */
    public org.openqa.selenium.devtools.v85.security.model.SecurityState getSecurityState() {
        return securityState;
    }

    /**
     * Security state details about the page certificate.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v85.security.model.CertificateSecurityState> getCertificateSecurityState() {
        return certificateSecurityState;
    }

    /**
     * The type of Safety Tip triggered on the page. Note that this field will be set even if the Safety Tip UI was not actually shown.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v85.security.model.SafetyTipInfo> getSafetyTipInfo() {
        return safetyTipInfo;
    }

    /**
     * Array of security state issues ids.
     */
    public java.util.List<java.lang.String> getSecurityStateIssueIds() {
        return securityStateIssueIds;
    }

    private static VisibleSecurityState fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v85.security.model.SecurityState securityState = null;
        java.util.Optional<org.openqa.selenium.devtools.v85.security.model.CertificateSecurityState> certificateSecurityState = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v85.security.model.SafetyTipInfo> safetyTipInfo = java.util.Optional.empty();
        java.util.List<java.lang.String> securityStateIssueIds = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "securityState":
                    securityState = input.read(org.openqa.selenium.devtools.v85.security.model.SecurityState.class);
                    break;
                case "certificateSecurityState":
                    certificateSecurityState = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v85.security.model.CertificateSecurityState.class));
                    break;
                case "safetyTipInfo":
                    safetyTipInfo = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v85.security.model.SafetyTipInfo.class));
                    break;
                case "securityStateIssueIds":
                    securityStateIssueIds = input.read(new com.google.common.reflect.TypeToken<java.util.List<java.lang.String>>() {
                    }.getType());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new VisibleSecurityState(securityState, certificateSecurityState, safetyTipInfo, securityStateIssueIds);
    }
}
