/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v85.emulation.model;

import java.util.List;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v85.emulation.model.UserAgentBrandVersion;
import org.openqa.selenium.json.JsonInput;

@Beta
public class UserAgentMetadata {
    private final List<UserAgentBrandVersion> brands;
    private final String fullVersion;
    private final String platform;
    private final String platformVersion;
    private final String architecture;
    private final String model;
    private final Boolean mobile;

    public UserAgentMetadata(List<UserAgentBrandVersion> brands, String fullVersion, String platform, String platformVersion, String architecture, String model, Boolean mobile) {
        this.brands = Objects.requireNonNull(brands, "brands is required");
        this.fullVersion = Objects.requireNonNull(fullVersion, "fullVersion is required");
        this.platform = Objects.requireNonNull(platform, "platform is required");
        this.platformVersion = Objects.requireNonNull(platformVersion, "platformVersion is required");
        this.architecture = Objects.requireNonNull(architecture, "architecture is required");
        this.model = Objects.requireNonNull(model, "model is required");
        this.mobile = Objects.requireNonNull(mobile, "mobile is required");
    }

    public List<UserAgentBrandVersion> getBrands() {
        return this.brands;
    }

    public String getFullVersion() {
        return this.fullVersion;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getPlatformVersion() {
        return this.platformVersion;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public String getModel() {
        return this.model;
    }

    public Boolean getMobile() {
        return this.mobile;
    }

    private static UserAgentMetadata fromJson(JsonInput input) {
        List brands = null;
        String fullVersion = null;
        String platform = null;
        String platformVersion = null;
        String architecture = null;
        String model = null;
        Boolean mobile = false;
        input.beginObject();
        block18: while (input.hasNext()) {
            switch (input.nextName()) {
                case "brands": {
                    brands = input.readArray(UserAgentBrandVersion.class);
                    continue block18;
                }
                case "fullVersion": {
                    fullVersion = input.nextString();
                    continue block18;
                }
                case "platform": {
                    platform = input.nextString();
                    continue block18;
                }
                case "platformVersion": {
                    platformVersion = input.nextString();
                    continue block18;
                }
                case "architecture": {
                    architecture = input.nextString();
                    continue block18;
                }
                case "model": {
                    model = input.nextString();
                    continue block18;
                }
                case "mobile": {
                    mobile = input.nextBoolean();
                    continue block18;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new UserAgentMetadata(brands, fullVersion, platform, platformVersion, architecture, model, mobile);
    }
}

