package org.openqa.selenium.devtools.v85.accessibility;

import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.ConverterFunctions;
import java.util.Map;
import java.util.LinkedHashMap;
import org.openqa.selenium.json.JsonInput;

@Beta()
public class Accessibility {

    /**
     * Disables the accessibility domain.
     */
    public static Command<Void> disable() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Accessibility.disable", Map.copyOf(params));
    }

    /**
     * Enables the accessibility domain which causes `AXNodeId`s to remain consistent between method calls.
     * This turns on accessibility for the page, which can impact performance until accessibility is disabled.
     */
    public static Command<Void> enable() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Accessibility.enable", Map.copyOf(params));
    }

    /**
     * Fetches the accessibility node and partial accessibility tree for this DOM node, if it exists.
     */
    @Beta()
    public static Command<java.util.List<org.openqa.selenium.devtools.v85.accessibility.model.AXNode>> getPartialAXTree(java.util.Optional<org.openqa.selenium.devtools.v85.dom.model.NodeId> nodeId, java.util.Optional<org.openqa.selenium.devtools.v85.dom.model.BackendNodeId> backendNodeId, java.util.Optional<org.openqa.selenium.devtools.v85.runtime.model.RemoteObjectId> objectId, java.util.Optional<java.lang.Boolean> fetchRelatives) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        nodeId.ifPresent(p -> params.put("nodeId", p));
        backendNodeId.ifPresent(p -> params.put("backendNodeId", p));
        objectId.ifPresent(p -> params.put("objectId", p));
        fetchRelatives.ifPresent(p -> params.put("fetchRelatives", p));
        return new Command<>("Accessibility.getPartialAXTree", Map.copyOf(params), ConverterFunctions.map("nodes", java.util.List.class));
    }

    /**
     * Fetches the entire accessibility tree
     */
    @Beta()
    public static Command<java.util.List<org.openqa.selenium.devtools.v85.accessibility.model.AXNode>> getFullAXTree() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("Accessibility.getFullAXTree", Map.copyOf(params), ConverterFunctions.map("nodes", java.util.List.class));
    }
}
