/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v84.runtime.model;

import com.google.common.reflect.TypeToken;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v84.runtime.model.ExecutionContextId;
import org.openqa.selenium.json.JsonInput;

public class ExecutionContextDescription {
    private final ExecutionContextId id;
    private final String origin;
    private final String name;
    private final Optional<Map<String, Object>> auxData;

    public ExecutionContextDescription(ExecutionContextId id, String origin, String name, Optional<Map<String, Object>> auxData) {
        this.id = Objects.requireNonNull(id, "id is required");
        this.origin = Objects.requireNonNull(origin, "origin is required");
        this.name = Objects.requireNonNull(name, "name is required");
        this.auxData = auxData;
    }

    public ExecutionContextId getId() {
        return this.id;
    }

    public String getOrigin() {
        return this.origin;
    }

    public String getName() {
        return this.name;
    }

    public Optional<Map<String, Object>> getAuxData() {
        return this.auxData;
    }

    private static ExecutionContextDescription fromJson(JsonInput input) {
        ExecutionContextId id = null;
        String origin = null;
        String name = null;
        Optional<Map<String, Object>> auxData = Optional.empty();
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "id": {
                    id = (ExecutionContextId)input.read(ExecutionContextId.class);
                    continue block12;
                }
                case "origin": {
                    origin = input.nextString();
                    continue block12;
                }
                case "name": {
                    name = input.nextString();
                    continue block12;
                }
                case "auxData": {
                    auxData = Optional.ofNullable((Map)input.read(new TypeToken<Map<String, Object>>(){}.getType()));
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ExecutionContextDescription(id, origin, name, auxData);
    }
}

