/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v84.network.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v84.network.model.BlockedReason;
import org.openqa.selenium.devtools.v84.network.model.MonotonicTime;
import org.openqa.selenium.devtools.v84.network.model.RequestId;
import org.openqa.selenium.devtools.v84.network.model.ResourceType;
import org.openqa.selenium.json.JsonInput;

public class LoadingFailed {
    private final RequestId requestId;
    private final MonotonicTime timestamp;
    private final ResourceType type;
    private final String errorText;
    private final Optional<Boolean> canceled;
    private final Optional<BlockedReason> blockedReason;

    public LoadingFailed(RequestId requestId, MonotonicTime timestamp, ResourceType type, String errorText, Optional<Boolean> canceled, Optional<BlockedReason> blockedReason) {
        this.requestId = Objects.requireNonNull(requestId, "requestId is required");
        this.timestamp = Objects.requireNonNull(timestamp, "timestamp is required");
        this.type = Objects.requireNonNull(type, "type is required");
        this.errorText = Objects.requireNonNull(errorText, "errorText is required");
        this.canceled = canceled;
        this.blockedReason = blockedReason;
    }

    public RequestId getRequestId() {
        return this.requestId;
    }

    public MonotonicTime getTimestamp() {
        return this.timestamp;
    }

    public ResourceType getType() {
        return this.type;
    }

    public String getErrorText() {
        return this.errorText;
    }

    public Optional<Boolean> getCanceled() {
        return this.canceled;
    }

    public Optional<BlockedReason> getBlockedReason() {
        return this.blockedReason;
    }

    private static LoadingFailed fromJson(JsonInput input) {
        RequestId requestId = null;
        MonotonicTime timestamp = null;
        ResourceType type = null;
        String errorText = null;
        Optional<Boolean> canceled = Optional.empty();
        Optional<BlockedReason> blockedReason = Optional.empty();
        input.beginObject();
        block16: while (input.hasNext()) {
            switch (input.nextName()) {
                case "requestId": {
                    requestId = (RequestId)input.read(RequestId.class);
                    continue block16;
                }
                case "timestamp": {
                    timestamp = (MonotonicTime)input.read(MonotonicTime.class);
                    continue block16;
                }
                case "type": {
                    type = (ResourceType)((Object)input.read(ResourceType.class));
                    continue block16;
                }
                case "errorText": {
                    errorText = input.nextString();
                    continue block16;
                }
                case "canceled": {
                    canceled = Optional.ofNullable(input.nextBoolean());
                    continue block16;
                }
                case "blockedReason": {
                    blockedReason = Optional.ofNullable((BlockedReason)((Object)input.read(BlockedReason.class)));
                    continue block16;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new LoadingFailed(requestId, timestamp, type, errorText, canceled, blockedReason);
    }
}

