/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v145.storage.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v145.storage.model.AttributionReportingReportResult;
import org.openqa.selenium.json.JsonInput;

@Beta
public class AttributionReportingReportSent {
    private final String url;
    private final Map<String, Object> body;
    private final AttributionReportingReportResult result;
    private final Optional<Integer> netError;
    private final Optional<String> netErrorName;
    private final Optional<Integer> httpStatusCode;

    public AttributionReportingReportSent(String url, Map<String, Object> body, AttributionReportingReportResult result, Optional<Integer> netError, Optional<String> netErrorName, Optional<Integer> httpStatusCode) {
        this.url = Objects.requireNonNull(url, "url is required");
        this.body = Objects.requireNonNull(body, "body is required");
        this.result = Objects.requireNonNull(result, "result is required");
        this.netError = netError;
        this.netErrorName = netErrorName;
        this.httpStatusCode = httpStatusCode;
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, Object> getBody() {
        return this.body;
    }

    public AttributionReportingReportResult getResult() {
        return this.result;
    }

    public Optional<Integer> getNetError() {
        return this.netError;
    }

    public Optional<String> getNetErrorName() {
        return this.netErrorName;
    }

    public Optional<Integer> getHttpStatusCode() {
        return this.httpStatusCode;
    }

    private static AttributionReportingReportSent fromJson(JsonInput input) {
        String url = null;
        Map body = null;
        AttributionReportingReportResult result = null;
        Optional<Integer> netError = Optional.empty();
        Optional<String> netErrorName = Optional.empty();
        Optional<Integer> httpStatusCode = Optional.empty();
        input.beginObject();
        block16: while (input.hasNext()) {
            switch (input.nextName()) {
                case "url": {
                    url = input.nextString();
                    continue block16;
                }
                case "body": {
                    body = (Map)input.read(Map.class);
                    continue block16;
                }
                case "result": {
                    result = (AttributionReportingReportResult)((Object)input.read(AttributionReportingReportResult.class));
                    continue block16;
                }
                case "netError": {
                    netError = Optional.ofNullable(input.nextNumber().intValue());
                    continue block16;
                }
                case "netErrorName": {
                    netErrorName = Optional.ofNullable(input.nextString());
                    continue block16;
                }
                case "httpStatusCode": {
                    httpStatusCode = Optional.ofNullable(input.nextNumber().intValue());
                    continue block16;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new AttributionReportingReportSent(url, body, result, netError, netErrorName, httpStatusCode);
    }
}

