/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v145.network.model;

import java.util.List;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v145.network.model.DeviceBoundSessionUrlRule;
import org.openqa.selenium.json.JsonInput;

@Beta
public class DeviceBoundSessionInclusionRules {
    private final String origin;
    private final Boolean includeSite;
    private final List<DeviceBoundSessionUrlRule> urlRules;

    public DeviceBoundSessionInclusionRules(String origin, Boolean includeSite, List<DeviceBoundSessionUrlRule> urlRules) {
        this.origin = Objects.requireNonNull(origin, "origin is required");
        this.includeSite = Objects.requireNonNull(includeSite, "includeSite is required");
        this.urlRules = Objects.requireNonNull(urlRules, "urlRules is required");
    }

    public String getOrigin() {
        return this.origin;
    }

    public Boolean getIncludeSite() {
        return this.includeSite;
    }

    public List<DeviceBoundSessionUrlRule> getUrlRules() {
        return this.urlRules;
    }

    private static DeviceBoundSessionInclusionRules fromJson(JsonInput input) {
        String origin = null;
        Boolean includeSite = false;
        List urlRules = null;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "origin": {
                    origin = input.nextString();
                    continue block10;
                }
                case "includeSite": {
                    includeSite = input.nextBoolean();
                    continue block10;
                }
                case "urlRules": {
                    urlRules = input.readArray(DeviceBoundSessionUrlRule.class);
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new DeviceBoundSessionInclusionRules(origin, includeSite, urlRules);
    }
}

