/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v145.network.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v145.network.model.ChallengeEventDetails;
import org.openqa.selenium.devtools.v145.network.model.CreationEventDetails;
import org.openqa.selenium.devtools.v145.network.model.DeviceBoundSessionEventId;
import org.openqa.selenium.devtools.v145.network.model.RefreshEventDetails;
import org.openqa.selenium.devtools.v145.network.model.TerminationEventDetails;
import org.openqa.selenium.json.JsonInput;

@Beta
public class DeviceBoundSessionEventOccurred {
    private final DeviceBoundSessionEventId eventId;
    private final String site;
    private final Boolean succeeded;
    private final Optional<String> sessionId;
    private final Optional<CreationEventDetails> creationEventDetails;
    private final Optional<RefreshEventDetails> refreshEventDetails;
    private final Optional<TerminationEventDetails> terminationEventDetails;
    private final Optional<ChallengeEventDetails> challengeEventDetails;

    public DeviceBoundSessionEventOccurred(DeviceBoundSessionEventId eventId, String site, Boolean succeeded, Optional<String> sessionId, Optional<CreationEventDetails> creationEventDetails, Optional<RefreshEventDetails> refreshEventDetails, Optional<TerminationEventDetails> terminationEventDetails, Optional<ChallengeEventDetails> challengeEventDetails) {
        this.eventId = Objects.requireNonNull(eventId, "eventId is required");
        this.site = Objects.requireNonNull(site, "site is required");
        this.succeeded = Objects.requireNonNull(succeeded, "succeeded is required");
        this.sessionId = sessionId;
        this.creationEventDetails = creationEventDetails;
        this.refreshEventDetails = refreshEventDetails;
        this.terminationEventDetails = terminationEventDetails;
        this.challengeEventDetails = challengeEventDetails;
    }

    public DeviceBoundSessionEventId getEventId() {
        return this.eventId;
    }

    public String getSite() {
        return this.site;
    }

    public Boolean getSucceeded() {
        return this.succeeded;
    }

    public Optional<String> getSessionId() {
        return this.sessionId;
    }

    public Optional<CreationEventDetails> getCreationEventDetails() {
        return this.creationEventDetails;
    }

    public Optional<RefreshEventDetails> getRefreshEventDetails() {
        return this.refreshEventDetails;
    }

    public Optional<TerminationEventDetails> getTerminationEventDetails() {
        return this.terminationEventDetails;
    }

    public Optional<ChallengeEventDetails> getChallengeEventDetails() {
        return this.challengeEventDetails;
    }

    private static DeviceBoundSessionEventOccurred fromJson(JsonInput input) {
        DeviceBoundSessionEventId eventId = null;
        String site = null;
        Boolean succeeded = false;
        Optional<String> sessionId = Optional.empty();
        Optional<CreationEventDetails> creationEventDetails = Optional.empty();
        Optional<RefreshEventDetails> refreshEventDetails = Optional.empty();
        Optional<TerminationEventDetails> terminationEventDetails = Optional.empty();
        Optional<ChallengeEventDetails> challengeEventDetails = Optional.empty();
        input.beginObject();
        block20: while (input.hasNext()) {
            switch (input.nextName()) {
                case "eventId": {
                    eventId = (DeviceBoundSessionEventId)input.read(DeviceBoundSessionEventId.class);
                    continue block20;
                }
                case "site": {
                    site = input.nextString();
                    continue block20;
                }
                case "succeeded": {
                    succeeded = input.nextBoolean();
                    continue block20;
                }
                case "sessionId": {
                    sessionId = Optional.ofNullable(input.nextString());
                    continue block20;
                }
                case "creationEventDetails": {
                    creationEventDetails = Optional.ofNullable((CreationEventDetails)input.read(CreationEventDetails.class));
                    continue block20;
                }
                case "refreshEventDetails": {
                    refreshEventDetails = Optional.ofNullable((RefreshEventDetails)input.read(RefreshEventDetails.class));
                    continue block20;
                }
                case "terminationEventDetails": {
                    terminationEventDetails = Optional.ofNullable((TerminationEventDetails)input.read(TerminationEventDetails.class));
                    continue block20;
                }
                case "challengeEventDetails": {
                    challengeEventDetails = Optional.ofNullable((ChallengeEventDetails)input.read(ChallengeEventDetails.class));
                    continue block20;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new DeviceBoundSessionEventOccurred(eventId, site, succeeded, sessionId, creationEventDetails, refreshEventDetails, terminationEventDetails, challengeEventDetails);
    }
}

