/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v145.network.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v145.network.model.CookieSameSite;
import org.openqa.selenium.json.JsonInput;

@Beta
public class DeviceBoundSessionCookieCraving {
    private final String name;
    private final String domain;
    private final String path;
    private final Boolean secure;
    private final Boolean httpOnly;
    private final Optional<CookieSameSite> sameSite;

    public DeviceBoundSessionCookieCraving(String name, String domain, String path, Boolean secure, Boolean httpOnly, Optional<CookieSameSite> sameSite) {
        this.name = Objects.requireNonNull(name, "name is required");
        this.domain = Objects.requireNonNull(domain, "domain is required");
        this.path = Objects.requireNonNull(path, "path is required");
        this.secure = Objects.requireNonNull(secure, "secure is required");
        this.httpOnly = Objects.requireNonNull(httpOnly, "httpOnly is required");
        this.sameSite = sameSite;
    }

    public String getName() {
        return this.name;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getPath() {
        return this.path;
    }

    public Boolean getSecure() {
        return this.secure;
    }

    public Boolean getHttpOnly() {
        return this.httpOnly;
    }

    public Optional<CookieSameSite> getSameSite() {
        return this.sameSite;
    }

    private static DeviceBoundSessionCookieCraving fromJson(JsonInput input) {
        String name = null;
        String domain = null;
        String path = null;
        Boolean secure = false;
        Boolean httpOnly = false;
        Optional<CookieSameSite> sameSite = Optional.empty();
        input.beginObject();
        block16: while (input.hasNext()) {
            switch (input.nextName()) {
                case "name": {
                    name = input.nextString();
                    continue block16;
                }
                case "domain": {
                    domain = input.nextString();
                    continue block16;
                }
                case "path": {
                    path = input.nextString();
                    continue block16;
                }
                case "secure": {
                    secure = input.nextBoolean();
                    continue block16;
                }
                case "httpOnly": {
                    httpOnly = input.nextBoolean();
                    continue block16;
                }
                case "sameSite": {
                    sameSite = Optional.ofNullable((CookieSameSite)((Object)input.read(CookieSameSite.class)));
                    continue block16;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new DeviceBoundSessionCookieCraving(name, domain, path, secure, httpOnly, sameSite);
    }
}

