/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v145.memory.model;

import java.util.List;
import java.util.Objects;
import org.openqa.selenium.devtools.v145.memory.model.Module;
import org.openqa.selenium.devtools.v145.memory.model.SamplingProfileNode;
import org.openqa.selenium.json.JsonInput;

public class SamplingProfile {
    private final List<SamplingProfileNode> samples;
    private final List<Module> modules;

    public SamplingProfile(List<SamplingProfileNode> samples, List<Module> modules) {
        this.samples = Objects.requireNonNull(samples, "samples is required");
        this.modules = Objects.requireNonNull(modules, "modules is required");
    }

    public List<SamplingProfileNode> getSamples() {
        return this.samples;
    }

    public List<Module> getModules() {
        return this.modules;
    }

    private static SamplingProfile fromJson(JsonInput input) {
        List samples = null;
        List modules = null;
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "samples": {
                    samples = input.readArray(SamplingProfileNode.class);
                    continue block8;
                }
                case "modules": {
                    modules = input.readArray(Module.class);
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new SamplingProfile(samples, modules);
    }
}

