/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v145.fedcm.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v145.fedcm.model.Account;
import org.openqa.selenium.devtools.v145.fedcm.model.DialogType;
import org.openqa.selenium.json.JsonInput;

public class DialogShown {
    private final String dialogId;
    private final DialogType dialogType;
    private final List<Account> accounts;
    private final String title;
    private final Optional<String> subtitle;

    public DialogShown(String dialogId, DialogType dialogType, List<Account> accounts, String title, Optional<String> subtitle) {
        this.dialogId = Objects.requireNonNull(dialogId, "dialogId is required");
        this.dialogType = Objects.requireNonNull(dialogType, "dialogType is required");
        this.accounts = Objects.requireNonNull(accounts, "accounts is required");
        this.title = Objects.requireNonNull(title, "title is required");
        this.subtitle = subtitle;
    }

    public String getDialogId() {
        return this.dialogId;
    }

    public DialogType getDialogType() {
        return this.dialogType;
    }

    public List<Account> getAccounts() {
        return this.accounts;
    }

    public String getTitle() {
        return this.title;
    }

    public Optional<String> getSubtitle() {
        return this.subtitle;
    }

    private static DialogShown fromJson(JsonInput input) {
        String dialogId = null;
        DialogType dialogType = null;
        List accounts = null;
        String title = null;
        Optional<String> subtitle = Optional.empty();
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "dialogId": {
                    dialogId = input.nextString();
                    continue block14;
                }
                case "dialogType": {
                    dialogType = (DialogType)((Object)input.read(DialogType.class));
                    continue block14;
                }
                case "accounts": {
                    accounts = input.readArray(Account.class);
                    continue block14;
                }
                case "title": {
                    title = input.nextString();
                    continue block14;
                }
                case "subtitle": {
                    subtitle = Optional.ofNullable(input.nextString());
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new DialogShown(dialogId, dialogType, accounts, title, subtitle);
    }
}

