/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v145.audits.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v145.audits.model.AffectedRequest;
import org.openqa.selenium.devtools.v145.audits.model.SourceCodeLocation;
import org.openqa.selenium.devtools.v145.audits.model.UserReidentificationIssueType;
import org.openqa.selenium.json.JsonInput;

public class UserReidentificationIssueDetails {
    private final UserReidentificationIssueType type;
    private final Optional<AffectedRequest> request;
    private final Optional<SourceCodeLocation> sourceCodeLocation;

    public UserReidentificationIssueDetails(UserReidentificationIssueType type, Optional<AffectedRequest> request, Optional<SourceCodeLocation> sourceCodeLocation) {
        this.type = Objects.requireNonNull(type, "type is required");
        this.request = request;
        this.sourceCodeLocation = sourceCodeLocation;
    }

    public UserReidentificationIssueType getType() {
        return this.type;
    }

    public Optional<AffectedRequest> getRequest() {
        return this.request;
    }

    public Optional<SourceCodeLocation> getSourceCodeLocation() {
        return this.sourceCodeLocation;
    }

    private static UserReidentificationIssueDetails fromJson(JsonInput input) {
        UserReidentificationIssueType type = null;
        Optional<AffectedRequest> request = Optional.empty();
        Optional<SourceCodeLocation> sourceCodeLocation = Optional.empty();
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "type": {
                    type = (UserReidentificationIssueType)((Object)input.read(UserReidentificationIssueType.class));
                    continue block10;
                }
                case "request": {
                    request = Optional.ofNullable((AffectedRequest)input.read(AffectedRequest.class));
                    continue block10;
                }
                case "sourceCodeLocation": {
                    sourceCodeLocation = Optional.ofNullable((SourceCodeLocation)input.read(SourceCodeLocation.class));
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new UserReidentificationIssueDetails(type, request, sourceCodeLocation);
    }
}

