/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v145.audits.model;

import java.util.Objects;
import org.openqa.selenium.devtools.v145.audits.model.ElementAccessibilityIssueReason;
import org.openqa.selenium.devtools.v145.dom.model.BackendNodeId;
import org.openqa.selenium.json.JsonInput;

public class ElementAccessibilityIssueDetails {
    private final BackendNodeId nodeId;
    private final ElementAccessibilityIssueReason elementAccessibilityIssueReason;
    private final Boolean hasDisallowedAttributes;

    public ElementAccessibilityIssueDetails(BackendNodeId nodeId, ElementAccessibilityIssueReason elementAccessibilityIssueReason, Boolean hasDisallowedAttributes) {
        this.nodeId = Objects.requireNonNull(nodeId, "nodeId is required");
        this.elementAccessibilityIssueReason = Objects.requireNonNull(elementAccessibilityIssueReason, "elementAccessibilityIssueReason is required");
        this.hasDisallowedAttributes = Objects.requireNonNull(hasDisallowedAttributes, "hasDisallowedAttributes is required");
    }

    public BackendNodeId getNodeId() {
        return this.nodeId;
    }

    public ElementAccessibilityIssueReason getElementAccessibilityIssueReason() {
        return this.elementAccessibilityIssueReason;
    }

    public Boolean getHasDisallowedAttributes() {
        return this.hasDisallowedAttributes;
    }

    private static ElementAccessibilityIssueDetails fromJson(JsonInput input) {
        BackendNodeId nodeId = null;
        ElementAccessibilityIssueReason elementAccessibilityIssueReason = null;
        Boolean hasDisallowedAttributes = false;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "nodeId": {
                    nodeId = (BackendNodeId)input.read(BackendNodeId.class);
                    continue block10;
                }
                case "elementAccessibilityIssueReason": {
                    elementAccessibilityIssueReason = (ElementAccessibilityIssueReason)((Object)input.read(ElementAccessibilityIssueReason.class));
                    continue block10;
                }
                case "hasDisallowedAttributes": {
                    hasDisallowedAttributes = input.nextBoolean();
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ElementAccessibilityIssueDetails(nodeId, elementAccessibilityIssueReason, hasDisallowedAttributes);
    }
}

