/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v144.storage.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.json.JsonInput;

public class SharedStoragePrivateAggregationConfig {
    private final Optional<String> aggregationCoordinatorOrigin;
    private final Optional<String> contextId;
    private final Integer filteringIdMaxBytes;
    private final Optional<Integer> maxContributions;

    public SharedStoragePrivateAggregationConfig(Optional<String> aggregationCoordinatorOrigin, Optional<String> contextId, Integer filteringIdMaxBytes, Optional<Integer> maxContributions) {
        this.aggregationCoordinatorOrigin = aggregationCoordinatorOrigin;
        this.contextId = contextId;
        this.filteringIdMaxBytes = Objects.requireNonNull(filteringIdMaxBytes, "filteringIdMaxBytes is required");
        this.maxContributions = maxContributions;
    }

    public Optional<String> getAggregationCoordinatorOrigin() {
        return this.aggregationCoordinatorOrigin;
    }

    public Optional<String> getContextId() {
        return this.contextId;
    }

    public Integer getFilteringIdMaxBytes() {
        return this.filteringIdMaxBytes;
    }

    public Optional<Integer> getMaxContributions() {
        return this.maxContributions;
    }

    private static SharedStoragePrivateAggregationConfig fromJson(JsonInput input) {
        Optional<String> aggregationCoordinatorOrigin = Optional.empty();
        Optional<String> contextId = Optional.empty();
        Integer filteringIdMaxBytes = 0;
        Optional<Integer> maxContributions = Optional.empty();
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "aggregationCoordinatorOrigin": {
                    aggregationCoordinatorOrigin = Optional.ofNullable(input.nextString());
                    continue block12;
                }
                case "contextId": {
                    contextId = Optional.ofNullable(input.nextString());
                    continue block12;
                }
                case "filteringIdMaxBytes": {
                    filteringIdMaxBytes = input.nextNumber().intValue();
                    continue block12;
                }
                case "maxContributions": {
                    maxContributions = Optional.ofNullable(input.nextNumber().intValue());
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new SharedStoragePrivateAggregationConfig(aggregationCoordinatorOrigin, contextId, filteringIdMaxBytes, maxContributions);
    }
}

