/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v144.css.model;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.v144.css.model.CSSStyle;
import org.openqa.selenium.devtools.v144.css.model.StyleSheetOrigin;
import org.openqa.selenium.devtools.v144.css.model.Value;
import org.openqa.selenium.devtools.v144.dom.model.StyleSheetId;
import org.openqa.selenium.json.JsonInput;

public class CSSAtRule {
    private final Type type;
    private final Optional<Subsection> subsection;
    private final Optional<Value> name;
    private final Optional<StyleSheetId> styleSheetId;
    private final StyleSheetOrigin origin;
    private final CSSStyle style;

    public CSSAtRule(Type type, Optional<Subsection> subsection, Optional<Value> name, Optional<StyleSheetId> styleSheetId, StyleSheetOrigin origin, CSSStyle style) {
        this.type = Objects.requireNonNull(type, "type is required");
        this.subsection = subsection;
        this.name = name;
        this.styleSheetId = styleSheetId;
        this.origin = Objects.requireNonNull(origin, "origin is required");
        this.style = Objects.requireNonNull(style, "style is required");
    }

    public Type getType() {
        return this.type;
    }

    public Optional<Subsection> getSubsection() {
        return this.subsection;
    }

    public Optional<Value> getName() {
        return this.name;
    }

    public Optional<StyleSheetId> getStyleSheetId() {
        return this.styleSheetId;
    }

    public StyleSheetOrigin getOrigin() {
        return this.origin;
    }

    public CSSStyle getStyle() {
        return this.style;
    }

    private static CSSAtRule fromJson(JsonInput input) {
        Type type = null;
        Optional<Subsection> subsection = Optional.empty();
        Optional<Value> name = Optional.empty();
        Optional<StyleSheetId> styleSheetId = Optional.empty();
        StyleSheetOrigin origin = null;
        CSSStyle style = null;
        input.beginObject();
        block16: while (input.hasNext()) {
            switch (input.nextName()) {
                case "type": {
                    type = Type.fromString(input.nextString());
                    continue block16;
                }
                case "subsection": {
                    subsection = Optional.ofNullable(Subsection.fromString(input.nextString()));
                    continue block16;
                }
                case "name": {
                    name = Optional.ofNullable((Value)input.read(Value.class));
                    continue block16;
                }
                case "styleSheetId": {
                    styleSheetId = Optional.ofNullable((StyleSheetId)input.read(StyleSheetId.class));
                    continue block16;
                }
                case "origin": {
                    origin = (StyleSheetOrigin)((Object)input.read(StyleSheetOrigin.class));
                    continue block16;
                }
                case "style": {
                    style = (CSSStyle)input.read(CSSStyle.class);
                    continue block16;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CSSAtRule(type, subsection, name, styleSheetId, origin, style);
    }

    public static enum Type {
        FONT_FACE("font-face"),
        FONT_FEATURE_VALUES("font-feature-values"),
        FONT_PALETTE_VALUES("font-palette-values");

        private String value;

        private Type(String value) {
            this.value = value;
        }

        public static Type fromString(String s) {
            return Arrays.stream(Type.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within Type "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Type fromJson(JsonInput input) {
            return Type.fromString(input.nextString());
        }
    }

    public static enum Subsection {
        SWASH("swash"),
        ANNOTATION("annotation"),
        ORNAMENTS("ornaments"),
        STYLISTIC("stylistic"),
        STYLESET("styleset"),
        CHARACTER_VARIANT("character-variant");

        private String value;

        private Subsection(String value) {
            this.value = value;
        }

        public static Subsection fromString(String s) {
            return Arrays.stream(Subsection.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within Subsection "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Subsection fromJson(JsonInput input) {
            return Subsection.fromString(input.nextString());
        }
    }
}

