/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v143.storage.model;

import java.util.List;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@Beta
public class RelatedWebsiteSet {
    private final List<String> primarySites;
    private final List<String> associatedSites;
    private final List<String> serviceSites;

    public RelatedWebsiteSet(List<String> primarySites, List<String> associatedSites, List<String> serviceSites) {
        this.primarySites = Objects.requireNonNull(primarySites, "primarySites is required");
        this.associatedSites = Objects.requireNonNull(associatedSites, "associatedSites is required");
        this.serviceSites = Objects.requireNonNull(serviceSites, "serviceSites is required");
    }

    public List<String> getPrimarySites() {
        return this.primarySites;
    }

    public List<String> getAssociatedSites() {
        return this.associatedSites;
    }

    public List<String> getServiceSites() {
        return this.serviceSites;
    }

    private static RelatedWebsiteSet fromJson(JsonInput input) {
        List primarySites = null;
        List associatedSites = null;
        List serviceSites = null;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "primarySites": {
                    primarySites = input.readArray(String.class);
                    continue block10;
                }
                case "associatedSites": {
                    associatedSites = input.readArray(String.class);
                    continue block10;
                }
                case "serviceSites": {
                    serviceSites = input.readArray(String.class);
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new RelatedWebsiteSet(primarySites, associatedSites, serviceSites);
    }
}

