/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v143.fedcm.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v143.fedcm.model.LoginState;
import org.openqa.selenium.json.JsonInput;

public class Account {
    private final String accountId;
    private final String email;
    private final String name;
    private final String givenName;
    private final String pictureUrl;
    private final String idpConfigUrl;
    private final String idpLoginUrl;
    private final LoginState loginState;
    private final Optional<String> termsOfServiceUrl;
    private final Optional<String> privacyPolicyUrl;

    public Account(String accountId, String email, String name, String givenName, String pictureUrl, String idpConfigUrl, String idpLoginUrl, LoginState loginState, Optional<String> termsOfServiceUrl, Optional<String> privacyPolicyUrl) {
        this.accountId = Objects.requireNonNull(accountId, "accountId is required");
        this.email = Objects.requireNonNull(email, "email is required");
        this.name = Objects.requireNonNull(name, "name is required");
        this.givenName = Objects.requireNonNull(givenName, "givenName is required");
        this.pictureUrl = Objects.requireNonNull(pictureUrl, "pictureUrl is required");
        this.idpConfigUrl = Objects.requireNonNull(idpConfigUrl, "idpConfigUrl is required");
        this.idpLoginUrl = Objects.requireNonNull(idpLoginUrl, "idpLoginUrl is required");
        this.loginState = Objects.requireNonNull(loginState, "loginState is required");
        this.termsOfServiceUrl = termsOfServiceUrl;
        this.privacyPolicyUrl = privacyPolicyUrl;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getEmail() {
        return this.email;
    }

    public String getName() {
        return this.name;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public String getPictureUrl() {
        return this.pictureUrl;
    }

    public String getIdpConfigUrl() {
        return this.idpConfigUrl;
    }

    public String getIdpLoginUrl() {
        return this.idpLoginUrl;
    }

    public LoginState getLoginState() {
        return this.loginState;
    }

    public Optional<String> getTermsOfServiceUrl() {
        return this.termsOfServiceUrl;
    }

    public Optional<String> getPrivacyPolicyUrl() {
        return this.privacyPolicyUrl;
    }

    private static Account fromJson(JsonInput input) {
        String accountId = null;
        String email = null;
        String name = null;
        String givenName = null;
        String pictureUrl = null;
        String idpConfigUrl = null;
        String idpLoginUrl = null;
        LoginState loginState = null;
        Optional<String> termsOfServiceUrl = Optional.empty();
        Optional<String> privacyPolicyUrl = Optional.empty();
        input.beginObject();
        block24: while (input.hasNext()) {
            switch (input.nextName()) {
                case "accountId": {
                    accountId = input.nextString();
                    continue block24;
                }
                case "email": {
                    email = input.nextString();
                    continue block24;
                }
                case "name": {
                    name = input.nextString();
                    continue block24;
                }
                case "givenName": {
                    givenName = input.nextString();
                    continue block24;
                }
                case "pictureUrl": {
                    pictureUrl = input.nextString();
                    continue block24;
                }
                case "idpConfigUrl": {
                    idpConfigUrl = input.nextString();
                    continue block24;
                }
                case "idpLoginUrl": {
                    idpLoginUrl = input.nextString();
                    continue block24;
                }
                case "loginState": {
                    loginState = (LoginState)((Object)input.read(LoginState.class));
                    continue block24;
                }
                case "termsOfServiceUrl": {
                    termsOfServiceUrl = Optional.ofNullable(input.nextString());
                    continue block24;
                }
                case "privacyPolicyUrl": {
                    privacyPolicyUrl = Optional.ofNullable(input.nextString());
                    continue block24;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new Account(accountId, email, name, givenName, pictureUrl, idpConfigUrl, idpLoginUrl, loginState, termsOfServiceUrl, privacyPolicyUrl);
    }
}

