/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v136.css.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v136.css.model.StyleSheetId;
import org.openqa.selenium.devtools.v136.css.model.StyleSheetOrigin;
import org.openqa.selenium.devtools.v136.dom.model.BackendNodeId;
import org.openqa.selenium.devtools.v136.page.model.FrameId;
import org.openqa.selenium.json.JsonInput;

public class CSSStyleSheetHeader {
    private final StyleSheetId styleSheetId;
    private final FrameId frameId;
    private final String sourceURL;
    private final Optional<String> sourceMapURL;
    private final StyleSheetOrigin origin;
    private final String title;
    private final Optional<BackendNodeId> ownerNode;
    private final Boolean disabled;
    private final Optional<Boolean> hasSourceURL;
    private final Boolean isInline;
    private final Boolean isMutable;
    private final Boolean isConstructed;
    private final Number startLine;
    private final Number startColumn;
    private final Number length;
    private final Number endLine;
    private final Number endColumn;
    private final Optional<Boolean> loadingFailed;

    public CSSStyleSheetHeader(StyleSheetId styleSheetId, FrameId frameId, String sourceURL, Optional<String> sourceMapURL, StyleSheetOrigin origin, String title, Optional<BackendNodeId> ownerNode, Boolean disabled, Optional<Boolean> hasSourceURL, Boolean isInline, Boolean isMutable, Boolean isConstructed, Number startLine, Number startColumn, Number length, Number endLine, Number endColumn, Optional<Boolean> loadingFailed) {
        this.styleSheetId = Objects.requireNonNull(styleSheetId, "styleSheetId is required");
        this.frameId = Objects.requireNonNull(frameId, "frameId is required");
        this.sourceURL = Objects.requireNonNull(sourceURL, "sourceURL is required");
        this.sourceMapURL = sourceMapURL;
        this.origin = Objects.requireNonNull(origin, "origin is required");
        this.title = Objects.requireNonNull(title, "title is required");
        this.ownerNode = ownerNode;
        this.disabled = Objects.requireNonNull(disabled, "disabled is required");
        this.hasSourceURL = hasSourceURL;
        this.isInline = Objects.requireNonNull(isInline, "isInline is required");
        this.isMutable = Objects.requireNonNull(isMutable, "isMutable is required");
        this.isConstructed = Objects.requireNonNull(isConstructed, "isConstructed is required");
        this.startLine = Objects.requireNonNull(startLine, "startLine is required");
        this.startColumn = Objects.requireNonNull(startColumn, "startColumn is required");
        this.length = Objects.requireNonNull(length, "length is required");
        this.endLine = Objects.requireNonNull(endLine, "endLine is required");
        this.endColumn = Objects.requireNonNull(endColumn, "endColumn is required");
        this.loadingFailed = loadingFailed;
    }

    public StyleSheetId getStyleSheetId() {
        return this.styleSheetId;
    }

    public FrameId getFrameId() {
        return this.frameId;
    }

    public String getSourceURL() {
        return this.sourceURL;
    }

    public Optional<String> getSourceMapURL() {
        return this.sourceMapURL;
    }

    public StyleSheetOrigin getOrigin() {
        return this.origin;
    }

    public String getTitle() {
        return this.title;
    }

    public Optional<BackendNodeId> getOwnerNode() {
        return this.ownerNode;
    }

    public Boolean getDisabled() {
        return this.disabled;
    }

    public Optional<Boolean> getHasSourceURL() {
        return this.hasSourceURL;
    }

    public Boolean getIsInline() {
        return this.isInline;
    }

    public Boolean getIsMutable() {
        return this.isMutable;
    }

    public Boolean getIsConstructed() {
        return this.isConstructed;
    }

    public Number getStartLine() {
        return this.startLine;
    }

    public Number getStartColumn() {
        return this.startColumn;
    }

    public Number getLength() {
        return this.length;
    }

    public Number getEndLine() {
        return this.endLine;
    }

    public Number getEndColumn() {
        return this.endColumn;
    }

    @Beta
    public Optional<Boolean> getLoadingFailed() {
        return this.loadingFailed;
    }

    private static CSSStyleSheetHeader fromJson(JsonInput input) {
        StyleSheetId styleSheetId = null;
        FrameId frameId = null;
        String sourceURL = null;
        Optional<String> sourceMapURL = Optional.empty();
        StyleSheetOrigin origin = null;
        String title = null;
        Optional<BackendNodeId> ownerNode = Optional.empty();
        Boolean disabled = false;
        Optional<Boolean> hasSourceURL = Optional.empty();
        Boolean isInline = false;
        Boolean isMutable = false;
        Boolean isConstructed = false;
        Number startLine = 0;
        Number startColumn = 0;
        Number length = 0;
        Number endLine = 0;
        Number endColumn = 0;
        Optional<Boolean> loadingFailed = Optional.empty();
        input.beginObject();
        block40: while (input.hasNext()) {
            switch (input.nextName()) {
                case "styleSheetId": {
                    styleSheetId = (StyleSheetId)input.read(StyleSheetId.class);
                    continue block40;
                }
                case "frameId": {
                    frameId = (FrameId)input.read(FrameId.class);
                    continue block40;
                }
                case "sourceURL": {
                    sourceURL = input.nextString();
                    continue block40;
                }
                case "sourceMapURL": {
                    sourceMapURL = Optional.ofNullable(input.nextString());
                    continue block40;
                }
                case "origin": {
                    origin = (StyleSheetOrigin)((Object)input.read(StyleSheetOrigin.class));
                    continue block40;
                }
                case "title": {
                    title = input.nextString();
                    continue block40;
                }
                case "ownerNode": {
                    ownerNode = Optional.ofNullable((BackendNodeId)input.read(BackendNodeId.class));
                    continue block40;
                }
                case "disabled": {
                    disabled = input.nextBoolean();
                    continue block40;
                }
                case "hasSourceURL": {
                    hasSourceURL = Optional.ofNullable(input.nextBoolean());
                    continue block40;
                }
                case "isInline": {
                    isInline = input.nextBoolean();
                    continue block40;
                }
                case "isMutable": {
                    isMutable = input.nextBoolean();
                    continue block40;
                }
                case "isConstructed": {
                    isConstructed = input.nextBoolean();
                    continue block40;
                }
                case "startLine": {
                    startLine = input.nextNumber();
                    continue block40;
                }
                case "startColumn": {
                    startColumn = input.nextNumber();
                    continue block40;
                }
                case "length": {
                    length = input.nextNumber();
                    continue block40;
                }
                case "endLine": {
                    endLine = input.nextNumber();
                    continue block40;
                }
                case "endColumn": {
                    endColumn = input.nextNumber();
                    continue block40;
                }
                case "loadingFailed": {
                    loadingFailed = Optional.ofNullable(input.nextBoolean());
                    continue block40;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CSSStyleSheetHeader(styleSheetId, frameId, sourceURL, sourceMapURL, origin, title, ownerNode, disabled, hasSourceURL, isInline, isMutable, isConstructed, startLine, startColumn, length, endLine, endColumn, loadingFailed);
    }
}

