package org.openqa.selenium.devtools.v134.heapprofiler;

import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.ConverterFunctions;
import java.util.Map;
import java.util.LinkedHashMap;
import org.openqa.selenium.json.JsonInput;

@Beta()
public class HeapProfiler {

    /**
     * Enables console to refer to the node with given id via $x (see Command Line API for more details
     * $x functions).
     */
    public static Command<Void> addInspectedHeapObject(org.openqa.selenium.devtools.v134.heapprofiler.model.HeapSnapshotObjectId heapObjectId) {
        java.util.Objects.requireNonNull(heapObjectId, "heapObjectId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("heapObjectId", heapObjectId);
        return new Command<>("HeapProfiler.addInspectedHeapObject", Map.copyOf(params));
    }

    public static Command<Void> collectGarbage() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("HeapProfiler.collectGarbage", Map.copyOf(params));
    }

    public static Command<Void> disable() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("HeapProfiler.disable", Map.copyOf(params));
    }

    public static Command<Void> enable() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("HeapProfiler.enable", Map.copyOf(params));
    }

    public static Command<org.openqa.selenium.devtools.v134.heapprofiler.model.HeapSnapshotObjectId> getHeapObjectId(org.openqa.selenium.devtools.v134.runtime.model.RemoteObjectId objectId) {
        java.util.Objects.requireNonNull(objectId, "objectId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("objectId", objectId);
        return new Command<>("HeapProfiler.getHeapObjectId", Map.copyOf(params), ConverterFunctions.map("heapSnapshotObjectId", org.openqa.selenium.devtools.v134.heapprofiler.model.HeapSnapshotObjectId.class));
    }

    public static Command<org.openqa.selenium.devtools.v134.runtime.model.RemoteObject> getObjectByHeapObjectId(org.openqa.selenium.devtools.v134.heapprofiler.model.HeapSnapshotObjectId objectId, java.util.Optional<java.lang.String> objectGroup) {
        java.util.Objects.requireNonNull(objectId, "objectId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("objectId", objectId);
        objectGroup.ifPresent(p -> params.put("objectGroup", p));
        return new Command<>("HeapProfiler.getObjectByHeapObjectId", Map.copyOf(params), ConverterFunctions.map("result", org.openqa.selenium.devtools.v134.runtime.model.RemoteObject.class));
    }

    public static Command<org.openqa.selenium.devtools.v134.heapprofiler.model.SamplingHeapProfile> getSamplingProfile() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("HeapProfiler.getSamplingProfile", Map.copyOf(params), ConverterFunctions.map("profile", org.openqa.selenium.devtools.v134.heapprofiler.model.SamplingHeapProfile.class));
    }

    public static Command<Void> startSampling(java.util.Optional<java.lang.Number> samplingInterval, java.util.Optional<java.lang.Boolean> includeObjectsCollectedByMajorGC, java.util.Optional<java.lang.Boolean> includeObjectsCollectedByMinorGC) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        samplingInterval.ifPresent(p -> params.put("samplingInterval", p));
        includeObjectsCollectedByMajorGC.ifPresent(p -> params.put("includeObjectsCollectedByMajorGC", p));
        includeObjectsCollectedByMinorGC.ifPresent(p -> params.put("includeObjectsCollectedByMinorGC", p));
        return new Command<>("HeapProfiler.startSampling", Map.copyOf(params));
    }

    public static Command<Void> startTrackingHeapObjects(java.util.Optional<java.lang.Boolean> trackAllocations) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        trackAllocations.ifPresent(p -> params.put("trackAllocations", p));
        return new Command<>("HeapProfiler.startTrackingHeapObjects", Map.copyOf(params));
    }

    public static Command<org.openqa.selenium.devtools.v134.heapprofiler.model.SamplingHeapProfile> stopSampling() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("HeapProfiler.stopSampling", Map.copyOf(params), ConverterFunctions.map("profile", org.openqa.selenium.devtools.v134.heapprofiler.model.SamplingHeapProfile.class));
    }

    public static Command<Void> stopTrackingHeapObjects(java.util.Optional<java.lang.Boolean> reportProgress, java.util.Optional<java.lang.Boolean> treatGlobalObjectsAsRoots, java.util.Optional<java.lang.Boolean> captureNumericValue, java.util.Optional<java.lang.Boolean> exposeInternals) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        reportProgress.ifPresent(p -> params.put("reportProgress", p));
        treatGlobalObjectsAsRoots.ifPresent(p -> params.put("treatGlobalObjectsAsRoots", p));
        captureNumericValue.ifPresent(p -> params.put("captureNumericValue", p));
        exposeInternals.ifPresent(p -> params.put("exposeInternals", p));
        return new Command<>("HeapProfiler.stopTrackingHeapObjects", Map.copyOf(params));
    }

    public static Command<Void> takeHeapSnapshot(java.util.Optional<java.lang.Boolean> reportProgress, java.util.Optional<java.lang.Boolean> treatGlobalObjectsAsRoots, java.util.Optional<java.lang.Boolean> captureNumericValue, java.util.Optional<java.lang.Boolean> exposeInternals) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        reportProgress.ifPresent(p -> params.put("reportProgress", p));
        treatGlobalObjectsAsRoots.ifPresent(p -> params.put("treatGlobalObjectsAsRoots", p));
        captureNumericValue.ifPresent(p -> params.put("captureNumericValue", p));
        exposeInternals.ifPresent(p -> params.put("exposeInternals", p));
        return new Command<>("HeapProfiler.takeHeapSnapshot", Map.copyOf(params));
    }

    public static Event<java.lang.String> addHeapSnapshotChunk() {
        return new Event<>("HeapProfiler.addHeapSnapshotChunk", ConverterFunctions.map("chunk", java.lang.String.class));
    }

    public static Event<java.util.List<java.lang.Integer>> heapStatsUpdate() {
        return new Event<>("HeapProfiler.heapStatsUpdate", ConverterFunctions.map("statsUpdate", input -> input.readArray(java.lang.Integer.class)));
    }

    public static Event<org.openqa.selenium.devtools.v134.heapprofiler.model.LastSeenObjectId> lastSeenObjectId() {
        return new Event<>("HeapProfiler.lastSeenObjectId", input -> input.read(org.openqa.selenium.devtools.v134.heapprofiler.model.LastSeenObjectId.class));
    }

    public static Event<org.openqa.selenium.devtools.v134.heapprofiler.model.ReportHeapSnapshotProgress> reportHeapSnapshotProgress() {
        return new Event<>("HeapProfiler.reportHeapSnapshotProgress", input -> input.read(org.openqa.selenium.devtools.v134.heapprofiler.model.ReportHeapSnapshotProgress.class));
    }

    public static Event<Void> resetProfiles() {
        return new Event<>("HeapProfiler.resetProfiles", ConverterFunctions.empty());
    }
}
