/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v134.bluetoothemulation;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.v134.bluetoothemulation.model.CentralState;
import org.openqa.selenium.devtools.v134.bluetoothemulation.model.ManufacturerData;
import org.openqa.selenium.devtools.v134.bluetoothemulation.model.ScanEntry;

@Beta
public class BluetoothEmulation {
    public static Command<Void> enable(CentralState state) {
        Objects.requireNonNull(state, "state is required");
        LinkedHashMap<String, CentralState> params = new LinkedHashMap<String, CentralState>();
        params.put("state", state);
        return new Command("BluetoothEmulation.enable", Map.copyOf(params));
    }

    public static Command<Void> disable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("BluetoothEmulation.disable", Map.copyOf(params));
    }

    public static Command<Void> simulatePreconnectedPeripheral(String address, String name, List<ManufacturerData> manufacturerData, List<String> knownServiceUuids) {
        Objects.requireNonNull(address, "address is required");
        Objects.requireNonNull(name, "name is required");
        Objects.requireNonNull(manufacturerData, "manufacturerData is required");
        Objects.requireNonNull(knownServiceUuids, "knownServiceUuids is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("address", address);
        params.put("name", name);
        params.put("manufacturerData", manufacturerData);
        params.put("knownServiceUuids", knownServiceUuids);
        return new Command("BluetoothEmulation.simulatePreconnectedPeripheral", Map.copyOf(params));
    }

    public static Command<Void> simulateAdvertisement(ScanEntry entry) {
        Objects.requireNonNull(entry, "entry is required");
        LinkedHashMap<String, ScanEntry> params = new LinkedHashMap<String, ScanEntry>();
        params.put("entry", entry);
        return new Command("BluetoothEmulation.simulateAdvertisement", Map.copyOf(params));
    }
}

