/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v133.css.model;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.v133.css.model.MediaQuery;
import org.openqa.selenium.devtools.v133.css.model.SourceRange;
import org.openqa.selenium.devtools.v133.css.model.StyleSheetId;
import org.openqa.selenium.json.JsonInput;

public class CSSMedia {
    private final String text;
    private final Source source;
    private final Optional<String> sourceURL;
    private final Optional<SourceRange> range;
    private final Optional<StyleSheetId> styleSheetId;
    private final Optional<List<MediaQuery>> mediaList;

    public CSSMedia(String text, Source source, Optional<String> sourceURL, Optional<SourceRange> range, Optional<StyleSheetId> styleSheetId, Optional<List<MediaQuery>> mediaList) {
        this.text = Objects.requireNonNull(text, "text is required");
        this.source = Objects.requireNonNull(source, "source is required");
        this.sourceURL = sourceURL;
        this.range = range;
        this.styleSheetId = styleSheetId;
        this.mediaList = mediaList;
    }

    public String getText() {
        return this.text;
    }

    public Source getSource() {
        return this.source;
    }

    public Optional<String> getSourceURL() {
        return this.sourceURL;
    }

    public Optional<SourceRange> getRange() {
        return this.range;
    }

    public Optional<StyleSheetId> getStyleSheetId() {
        return this.styleSheetId;
    }

    public Optional<List<MediaQuery>> getMediaList() {
        return this.mediaList;
    }

    private static CSSMedia fromJson(JsonInput input) {
        String text = null;
        Source source = null;
        Optional<String> sourceURL = Optional.empty();
        Optional<SourceRange> range = Optional.empty();
        Optional<StyleSheetId> styleSheetId = Optional.empty();
        Optional<List<MediaQuery>> mediaList = Optional.empty();
        input.beginObject();
        block16: while (input.hasNext()) {
            switch (input.nextName()) {
                case "text": {
                    text = input.nextString();
                    continue block16;
                }
                case "source": {
                    source = Source.fromString(input.nextString());
                    continue block16;
                }
                case "sourceURL": {
                    sourceURL = Optional.ofNullable(input.nextString());
                    continue block16;
                }
                case "range": {
                    range = Optional.ofNullable((SourceRange)input.read(SourceRange.class));
                    continue block16;
                }
                case "styleSheetId": {
                    styleSheetId = Optional.ofNullable((StyleSheetId)input.read(StyleSheetId.class));
                    continue block16;
                }
                case "mediaList": {
                    mediaList = Optional.ofNullable(input.readArray(MediaQuery.class));
                    continue block16;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CSSMedia(text, source, sourceURL, range, styleSheetId, mediaList);
    }

    public static enum Source {
        MEDIARULE("mediaRule"),
        IMPORTRULE("importRule"),
        LINKEDSHEET("linkedSheet"),
        INLINESHEET("inlineSheet");

        private String value;

        private Source(String value) {
            this.value = value;
        }

        public static Source fromString(String s) {
            return Arrays.stream(Source.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within Source "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Source fromJson(JsonInput input) {
            return Source.fromString(input.nextString());
        }
    }
}

