package org.openqa.selenium.devtools.v132.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * This issue warns when a referenced stylesheet couldn't be loaded.
 */
public class StylesheetLoadingIssueDetails {

    private final org.openqa.selenium.devtools.v132.audits.model.SourceCodeLocation sourceCodeLocation;

    private final org.openqa.selenium.devtools.v132.audits.model.StyleSheetLoadingIssueReason styleSheetLoadingIssueReason;

    private final java.util.Optional<org.openqa.selenium.devtools.v132.audits.model.FailedRequestInfo> failedRequestInfo;

    public StylesheetLoadingIssueDetails(org.openqa.selenium.devtools.v132.audits.model.SourceCodeLocation sourceCodeLocation, org.openqa.selenium.devtools.v132.audits.model.StyleSheetLoadingIssueReason styleSheetLoadingIssueReason, java.util.Optional<org.openqa.selenium.devtools.v132.audits.model.FailedRequestInfo> failedRequestInfo) {
        this.sourceCodeLocation = java.util.Objects.requireNonNull(sourceCodeLocation, "sourceCodeLocation is required");
        this.styleSheetLoadingIssueReason = java.util.Objects.requireNonNull(styleSheetLoadingIssueReason, "styleSheetLoadingIssueReason is required");
        this.failedRequestInfo = failedRequestInfo;
    }

    /**
     * Source code position that referenced the failing stylesheet.
     */
    public org.openqa.selenium.devtools.v132.audits.model.SourceCodeLocation getSourceCodeLocation() {
        return sourceCodeLocation;
    }

    /**
     * Reason why the stylesheet couldn't be loaded.
     */
    public org.openqa.selenium.devtools.v132.audits.model.StyleSheetLoadingIssueReason getStyleSheetLoadingIssueReason() {
        return styleSheetLoadingIssueReason;
    }

    /**
     * Contains additional info when the failure was due to a request.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v132.audits.model.FailedRequestInfo> getFailedRequestInfo() {
        return failedRequestInfo;
    }

    private static StylesheetLoadingIssueDetails fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v132.audits.model.SourceCodeLocation sourceCodeLocation = null;
        org.openqa.selenium.devtools.v132.audits.model.StyleSheetLoadingIssueReason styleSheetLoadingIssueReason = null;
        java.util.Optional<org.openqa.selenium.devtools.v132.audits.model.FailedRequestInfo> failedRequestInfo = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "sourceCodeLocation":
                    sourceCodeLocation = input.read(org.openqa.selenium.devtools.v132.audits.model.SourceCodeLocation.class);
                    break;
                case "styleSheetLoadingIssueReason":
                    styleSheetLoadingIssueReason = input.read(org.openqa.selenium.devtools.v132.audits.model.StyleSheetLoadingIssueReason.class);
                    break;
                case "failedRequestInfo":
                    failedRequestInfo = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v132.audits.model.FailedRequestInfo.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new StylesheetLoadingIssueDetails(sourceCodeLocation, styleSheetLoadingIssueReason, failedRequestInfo);
    }
}
