package org.openqa.selenium.devtools.v131.runtime.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Issued when execution context is destroyed.
 */
public class ExecutionContextDestroyed {

    private final org.openqa.selenium.devtools.v131.runtime.model.ExecutionContextId executionContextId;

    private final java.lang.String executionContextUniqueId;

    public ExecutionContextDestroyed(org.openqa.selenium.devtools.v131.runtime.model.ExecutionContextId executionContextId, java.lang.String executionContextUniqueId) {
        this.executionContextId = java.util.Objects.requireNonNull(executionContextId, "executionContextId is required");
        this.executionContextUniqueId = java.util.Objects.requireNonNull(executionContextUniqueId, "executionContextUniqueId is required");
    }

    /**
     * Id of the destroyed context
     */
    @Deprecated()
    public org.openqa.selenium.devtools.v131.runtime.model.ExecutionContextId getExecutionContextId() {
        return executionContextId;
    }

    /**
     * Unique Id of the destroyed context
     */
    @Beta()
    public java.lang.String getExecutionContextUniqueId() {
        return executionContextUniqueId;
    }

    private static ExecutionContextDestroyed fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v131.runtime.model.ExecutionContextId executionContextId = null;
        java.lang.String executionContextUniqueId = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "executionContextId":
                    executionContextId = input.read(org.openqa.selenium.devtools.v131.runtime.model.ExecutionContextId.class);
                    break;
                case "executionContextUniqueId":
                    executionContextUniqueId = input.nextString();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new ExecutionContextDestroyed(executionContextId, executionContextUniqueId);
    }
}
