package org.openqa.selenium.devtools.v130.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * The image definition used in both icon and screenshot.
 */
@org.openqa.selenium.Beta()
public class ImageResource {

    private final java.lang.String url;

    private final java.util.Optional<java.lang.String> sizes;

    private final java.util.Optional<java.lang.String> type;

    public ImageResource(java.lang.String url, java.util.Optional<java.lang.String> sizes, java.util.Optional<java.lang.String> type) {
        this.url = java.util.Objects.requireNonNull(url, "url is required");
        this.sizes = sizes;
        this.type = type;
    }

    /**
     * The src field in the definition, but changing to url in favor of
     * consistency.
     */
    public java.lang.String getUrl() {
        return url;
    }

    public java.util.Optional<java.lang.String> getSizes() {
        return sizes;
    }

    public java.util.Optional<java.lang.String> getType() {
        return type;
    }

    private static ImageResource fromJson(JsonInput input) {
        java.lang.String url = null;
        java.util.Optional<java.lang.String> sizes = java.util.Optional.empty();
        java.util.Optional<java.lang.String> type = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "url":
                    url = input.nextString();
                    break;
                case "sizes":
                    sizes = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "type":
                    type = java.util.Optional.ofNullable(input.nextString());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new ImageResource(url, sizes, type);
    }
}
