package org.openqa.selenium.devtools.v130.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * This issue warns about sites in the redirect chain of a finished navigation
 * that may be flagged as trackers and have their state cleared if they don't
 * receive a user interaction. Note that in this context 'site' means eTLD+1.
 * For example, if the URL `https://example.test:80/bounce` was in the
 * redirect chain, the site reported would be `example.test`.
 */
public class BounceTrackingIssueDetails {

    private final java.util.List<java.lang.String> trackingSites;

    public BounceTrackingIssueDetails(java.util.List<java.lang.String> trackingSites) {
        this.trackingSites = java.util.Objects.requireNonNull(trackingSites, "trackingSites is required");
    }

    public java.util.List<java.lang.String> getTrackingSites() {
        return trackingSites;
    }

    private static BounceTrackingIssueDetails fromJson(JsonInput input) {
        java.util.List<java.lang.String> trackingSites = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "trackingSites":
                    trackingSites = input.readArray(java.lang.String.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new BounceTrackingIssueDetails(trackingSites);
    }
}
