/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v128.tracing.model;

import java.util.Arrays;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

@Beta
public enum TracingBackend {
    AUTO("auto"),
    CHROME("chrome"),
    SYSTEM("system");

    private String value;

    private TracingBackend(String value) {
        this.value = value;
    }

    public static TracingBackend fromString(String s) {
        return Arrays.stream(TracingBackend.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within TracingBackend "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static TracingBackend fromJson(JsonInput input) {
        return TracingBackend.fromString(input.nextString());
    }
}

