package org.openqa.selenium.devtools.v128.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public class CrossOriginOpenerPolicyStatus {

    private final org.openqa.selenium.devtools.v128.network.model.CrossOriginOpenerPolicyValue value;

    private final org.openqa.selenium.devtools.v128.network.model.CrossOriginOpenerPolicyValue reportOnlyValue;

    private final java.util.Optional<java.lang.String> reportingEndpoint;

    private final java.util.Optional<java.lang.String> reportOnlyReportingEndpoint;

    public CrossOriginOpenerPolicyStatus(org.openqa.selenium.devtools.v128.network.model.CrossOriginOpenerPolicyValue value, org.openqa.selenium.devtools.v128.network.model.CrossOriginOpenerPolicyValue reportOnlyValue, java.util.Optional<java.lang.String> reportingEndpoint, java.util.Optional<java.lang.String> reportOnlyReportingEndpoint) {
        this.value = java.util.Objects.requireNonNull(value, "value is required");
        this.reportOnlyValue = java.util.Objects.requireNonNull(reportOnlyValue, "reportOnlyValue is required");
        this.reportingEndpoint = reportingEndpoint;
        this.reportOnlyReportingEndpoint = reportOnlyReportingEndpoint;
    }

    public org.openqa.selenium.devtools.v128.network.model.CrossOriginOpenerPolicyValue getValue() {
        return value;
    }

    public org.openqa.selenium.devtools.v128.network.model.CrossOriginOpenerPolicyValue getReportOnlyValue() {
        return reportOnlyValue;
    }

    public java.util.Optional<java.lang.String> getReportingEndpoint() {
        return reportingEndpoint;
    }

    public java.util.Optional<java.lang.String> getReportOnlyReportingEndpoint() {
        return reportOnlyReportingEndpoint;
    }

    private static CrossOriginOpenerPolicyStatus fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v128.network.model.CrossOriginOpenerPolicyValue value = null;
        org.openqa.selenium.devtools.v128.network.model.CrossOriginOpenerPolicyValue reportOnlyValue = null;
        java.util.Optional<java.lang.String> reportingEndpoint = java.util.Optional.empty();
        java.util.Optional<java.lang.String> reportOnlyReportingEndpoint = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "value":
                    value = input.read(org.openqa.selenium.devtools.v128.network.model.CrossOriginOpenerPolicyValue.class);
                    break;
                case "reportOnlyValue":
                    reportOnlyValue = input.read(org.openqa.selenium.devtools.v128.network.model.CrossOriginOpenerPolicyValue.class);
                    break;
                case "reportingEndpoint":
                    reportingEndpoint = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "reportOnlyReportingEndpoint":
                    reportOnlyReportingEndpoint = java.util.Optional.ofNullable(input.nextString());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new CrossOriginOpenerPolicyStatus(value, reportOnlyValue, reportingEndpoint, reportOnlyReportingEndpoint);
    }
}
