package org.openqa.selenium.devtools.v125.preload.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * A key that identifies a preloading attempt.
 *
 * The url used is the url specified by the trigger (i.e. the initial URL), and
 * not the final url that is navigated to. For example, prerendering allows
 * same-origin main frame navigations during the attempt, but the attempt is
 * still keyed with the initial URL.
 */
public class PreloadingAttemptKey {

    private final org.openqa.selenium.devtools.v125.network.model.LoaderId loaderId;

    private final org.openqa.selenium.devtools.v125.preload.model.SpeculationAction action;

    private final java.lang.String url;

    private final java.util.Optional<org.openqa.selenium.devtools.v125.preload.model.SpeculationTargetHint> targetHint;

    public PreloadingAttemptKey(org.openqa.selenium.devtools.v125.network.model.LoaderId loaderId, org.openqa.selenium.devtools.v125.preload.model.SpeculationAction action, java.lang.String url, java.util.Optional<org.openqa.selenium.devtools.v125.preload.model.SpeculationTargetHint> targetHint) {
        this.loaderId = java.util.Objects.requireNonNull(loaderId, "loaderId is required");
        this.action = java.util.Objects.requireNonNull(action, "action is required");
        this.url = java.util.Objects.requireNonNull(url, "url is required");
        this.targetHint = targetHint;
    }

    public org.openqa.selenium.devtools.v125.network.model.LoaderId getLoaderId() {
        return loaderId;
    }

    public org.openqa.selenium.devtools.v125.preload.model.SpeculationAction getAction() {
        return action;
    }

    public java.lang.String getUrl() {
        return url;
    }

    public java.util.Optional<org.openqa.selenium.devtools.v125.preload.model.SpeculationTargetHint> getTargetHint() {
        return targetHint;
    }

    private static PreloadingAttemptKey fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v125.network.model.LoaderId loaderId = null;
        org.openqa.selenium.devtools.v125.preload.model.SpeculationAction action = null;
        java.lang.String url = null;
        java.util.Optional<org.openqa.selenium.devtools.v125.preload.model.SpeculationTargetHint> targetHint = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "loaderId":
                    loaderId = input.read(org.openqa.selenium.devtools.v125.network.model.LoaderId.class);
                    break;
                case "action":
                    action = input.read(org.openqa.selenium.devtools.v125.preload.model.SpeculationAction.class);
                    break;
                case "url":
                    url = input.nextString();
                    break;
                case "targetHint":
                    targetHint = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v125.preload.model.SpeculationTargetHint.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new PreloadingAttemptKey(loaderId, action, url, targetHint);
    }
}
