package org.openqa.selenium.devtools.v118.overlay.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public enum ColorFormat {

    RGB("rgb"), HSL("hsl"), HWB("hwb"), HEX("hex");

    private String value;

    ColorFormat(String value) {
        this.value = value;
    }

    public static ColorFormat fromString(String s) {
        return java.util.Arrays.stream(ColorFormat.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within ColorFormat "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static ColorFormat fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
