/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v118.browser.model;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v118.browser.model.Bucket;
import org.openqa.selenium.json.JsonInput;

@Beta
public class Histogram {
    private final String name;
    private final Integer sum;
    private final Integer count;
    private final List<Bucket> buckets;

    public Histogram(String name, Integer sum, Integer count, List<Bucket> buckets) {
        this.name = Objects.requireNonNull(name, "name is required");
        this.sum = Objects.requireNonNull(sum, "sum is required");
        this.count = Objects.requireNonNull(count, "count is required");
        this.buckets = Objects.requireNonNull(buckets, "buckets is required");
    }

    public String getName() {
        return this.name;
    }

    public Integer getSum() {
        return this.sum;
    }

    public Integer getCount() {
        return this.count;
    }

    public List<Bucket> getBuckets() {
        return this.buckets;
    }

    private static Histogram fromJson(JsonInput input) {
        String name = null;
        Integer sum = 0;
        Integer count = 0;
        List buckets = null;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "name": {
                    name = input.nextString();
                    continue block12;
                }
                case "sum": {
                    sum = input.nextNumber().intValue();
                    continue block12;
                }
                case "count": {
                    count = input.nextNumber().intValue();
                    continue block12;
                }
                case "buckets": {
                    buckets = (List)input.read(new TypeToken<List<Bucket>>(){}.getType());
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new Histogram(name, sum, count, buckets);
    }
}

