package org.openqa.selenium.devtools.v112.webauthn.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public class VirtualAuthenticatorOptions {

    private final org.openqa.selenium.devtools.v112.webauthn.model.AuthenticatorProtocol protocol;

    private final java.util.Optional<org.openqa.selenium.devtools.v112.webauthn.model.Ctap2Version> ctap2Version;

    private final org.openqa.selenium.devtools.v112.webauthn.model.AuthenticatorTransport transport;

    private final java.util.Optional<java.lang.Boolean> hasResidentKey;

    private final java.util.Optional<java.lang.Boolean> hasUserVerification;

    private final java.util.Optional<java.lang.Boolean> hasLargeBlob;

    private final java.util.Optional<java.lang.Boolean> hasCredBlob;

    private final java.util.Optional<java.lang.Boolean> hasMinPinLength;

    private final java.util.Optional<java.lang.Boolean> hasPrf;

    private final java.util.Optional<java.lang.Boolean> automaticPresenceSimulation;

    private final java.util.Optional<java.lang.Boolean> isUserVerified;

    public VirtualAuthenticatorOptions(org.openqa.selenium.devtools.v112.webauthn.model.AuthenticatorProtocol protocol, java.util.Optional<org.openqa.selenium.devtools.v112.webauthn.model.Ctap2Version> ctap2Version, org.openqa.selenium.devtools.v112.webauthn.model.AuthenticatorTransport transport, java.util.Optional<java.lang.Boolean> hasResidentKey, java.util.Optional<java.lang.Boolean> hasUserVerification, java.util.Optional<java.lang.Boolean> hasLargeBlob, java.util.Optional<java.lang.Boolean> hasCredBlob, java.util.Optional<java.lang.Boolean> hasMinPinLength, java.util.Optional<java.lang.Boolean> hasPrf, java.util.Optional<java.lang.Boolean> automaticPresenceSimulation, java.util.Optional<java.lang.Boolean> isUserVerified) {
        this.protocol = java.util.Objects.requireNonNull(protocol, "protocol is required");
        this.ctap2Version = ctap2Version;
        this.transport = java.util.Objects.requireNonNull(transport, "transport is required");
        this.hasResidentKey = hasResidentKey;
        this.hasUserVerification = hasUserVerification;
        this.hasLargeBlob = hasLargeBlob;
        this.hasCredBlob = hasCredBlob;
        this.hasMinPinLength = hasMinPinLength;
        this.hasPrf = hasPrf;
        this.automaticPresenceSimulation = automaticPresenceSimulation;
        this.isUserVerified = isUserVerified;
    }

    public org.openqa.selenium.devtools.v112.webauthn.model.AuthenticatorProtocol getProtocol() {
        return protocol;
    }

    /**
     * Defaults to ctap2_0. Ignored if |protocol| == u2f.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v112.webauthn.model.Ctap2Version> getCtap2Version() {
        return ctap2Version;
    }

    public org.openqa.selenium.devtools.v112.webauthn.model.AuthenticatorTransport getTransport() {
        return transport;
    }

    /**
     * Defaults to false.
     */
    public java.util.Optional<java.lang.Boolean> getHasResidentKey() {
        return hasResidentKey;
    }

    /**
     * Defaults to false.
     */
    public java.util.Optional<java.lang.Boolean> getHasUserVerification() {
        return hasUserVerification;
    }

    /**
     * If set to true, the authenticator will support the largeBlob extension.
     * https://w3c.github.io/webauthn#largeBlob
     * Defaults to false.
     */
    public java.util.Optional<java.lang.Boolean> getHasLargeBlob() {
        return hasLargeBlob;
    }

    /**
     * If set to true, the authenticator will support the credBlob extension.
     * https://fidoalliance.org/specs/fido-v2.1-rd-20201208/fido-client-to-authenticator-protocol-v2.1-rd-20201208.html#sctn-credBlob-extension
     * Defaults to false.
     */
    public java.util.Optional<java.lang.Boolean> getHasCredBlob() {
        return hasCredBlob;
    }

    /**
     * If set to true, the authenticator will support the minPinLength extension.
     * https://fidoalliance.org/specs/fido-v2.1-ps-20210615/fido-client-to-authenticator-protocol-v2.1-ps-20210615.html#sctn-minpinlength-extension
     * Defaults to false.
     */
    public java.util.Optional<java.lang.Boolean> getHasMinPinLength() {
        return hasMinPinLength;
    }

    /**
     * If set to true, the authenticator will support the prf extension.
     * https://w3c.github.io/webauthn/#prf-extension
     * Defaults to false.
     */
    public java.util.Optional<java.lang.Boolean> getHasPrf() {
        return hasPrf;
    }

    /**
     * If set to true, tests of user presence will succeed immediately.
     * Otherwise, they will not be resolved. Defaults to true.
     */
    public java.util.Optional<java.lang.Boolean> getAutomaticPresenceSimulation() {
        return automaticPresenceSimulation;
    }

    /**
     * Sets whether User Verification succeeds or fails for an authenticator.
     * Defaults to false.
     */
    public java.util.Optional<java.lang.Boolean> getIsUserVerified() {
        return isUserVerified;
    }

    private static VirtualAuthenticatorOptions fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v112.webauthn.model.AuthenticatorProtocol protocol = null;
        java.util.Optional<org.openqa.selenium.devtools.v112.webauthn.model.Ctap2Version> ctap2Version = java.util.Optional.empty();
        org.openqa.selenium.devtools.v112.webauthn.model.AuthenticatorTransport transport = null;
        java.util.Optional<java.lang.Boolean> hasResidentKey = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> hasUserVerification = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> hasLargeBlob = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> hasCredBlob = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> hasMinPinLength = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> hasPrf = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> automaticPresenceSimulation = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> isUserVerified = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "protocol":
                    protocol = input.read(org.openqa.selenium.devtools.v112.webauthn.model.AuthenticatorProtocol.class);
                    break;
                case "ctap2Version":
                    ctap2Version = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v112.webauthn.model.Ctap2Version.class));
                    break;
                case "transport":
                    transport = input.read(org.openqa.selenium.devtools.v112.webauthn.model.AuthenticatorTransport.class);
                    break;
                case "hasResidentKey":
                    hasResidentKey = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "hasUserVerification":
                    hasUserVerification = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "hasLargeBlob":
                    hasLargeBlob = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "hasCredBlob":
                    hasCredBlob = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "hasMinPinLength":
                    hasMinPinLength = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "hasPrf":
                    hasPrf = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "automaticPresenceSimulation":
                    automaticPresenceSimulation = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "isUserVerified":
                    isUserVerified = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new VirtualAuthenticatorOptions(protocol, ctap2Version, transport, hasResidentKey, hasUserVerification, hasLargeBlob, hasCredBlob, hasMinPinLength, hasPrf, automaticPresenceSimulation, isUserVerified);
    }
}
