/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v112.profiler.model;

import java.util.Objects;
import org.openqa.selenium.json.JsonInput;

public class CoverageRange {
    private final Integer startOffset;
    private final Integer endOffset;
    private final Integer count;

    public CoverageRange(Integer startOffset, Integer endOffset, Integer count) {
        this.startOffset = Objects.requireNonNull(startOffset, "startOffset is required");
        this.endOffset = Objects.requireNonNull(endOffset, "endOffset is required");
        this.count = Objects.requireNonNull(count, "count is required");
    }

    public Integer getStartOffset() {
        return this.startOffset;
    }

    public Integer getEndOffset() {
        return this.endOffset;
    }

    public Integer getCount() {
        return this.count;
    }

    private static CoverageRange fromJson(JsonInput input) {
        Integer startOffset = 0;
        Integer endOffset = 0;
        Integer count = 0;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "startOffset": {
                    startOffset = input.nextNumber().intValue();
                    continue block10;
                }
                case "endOffset": {
                    endOffset = input.nextNumber().intValue();
                    continue block10;
                }
                case "count": {
                    count = input.nextNumber().intValue();
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CoverageRange(startOffset, endOffset, count);
    }
}

