/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v112.css.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v112.css.model.SourceRange;
import org.openqa.selenium.devtools.v112.css.model.StyleSheetId;
import org.openqa.selenium.json.JsonInput;

@Beta
public class CSSLayer {
    private final String text;
    private final Optional<SourceRange> range;
    private final Optional<StyleSheetId> styleSheetId;

    public CSSLayer(String text, Optional<SourceRange> range, Optional<StyleSheetId> styleSheetId) {
        this.text = Objects.requireNonNull(text, "text is required");
        this.range = range;
        this.styleSheetId = styleSheetId;
    }

    public String getText() {
        return this.text;
    }

    public Optional<SourceRange> getRange() {
        return this.range;
    }

    public Optional<StyleSheetId> getStyleSheetId() {
        return this.styleSheetId;
    }

    private static CSSLayer fromJson(JsonInput input) {
        String text = null;
        Optional<SourceRange> range = Optional.empty();
        Optional<StyleSheetId> styleSheetId = Optional.empty();
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "text": {
                    text = input.nextString();
                    continue block10;
                }
                case "range": {
                    range = Optional.ofNullable((SourceRange)input.read(SourceRange.class));
                    continue block10;
                }
                case "styleSheetId": {
                    styleSheetId = Optional.ofNullable((StyleSheetId)input.read(StyleSheetId.class));
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CSSLayer(text, range, styleSheetId);
    }
}

