package org.openqa.selenium.devtools.v112.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Fired for failed bfcache history navigations if BackForwardCache feature is enabled. Do
 * not assume any ordering with the Page.frameNavigated event. This event is fired only for
 * main-frame history navigation where the document changes (non-same-document navigations),
 * when bfcache navigation fails.
 */
@org.openqa.selenium.Beta()
public class BackForwardCacheNotUsed {

    private final org.openqa.selenium.devtools.v112.network.model.LoaderId loaderId;

    private final org.openqa.selenium.devtools.v112.page.model.FrameId frameId;

    private final java.util.List<org.openqa.selenium.devtools.v112.page.model.BackForwardCacheNotRestoredExplanation> notRestoredExplanations;

    private final java.util.Optional<org.openqa.selenium.devtools.v112.page.model.BackForwardCacheNotRestoredExplanationTree> notRestoredExplanationsTree;

    public BackForwardCacheNotUsed(org.openqa.selenium.devtools.v112.network.model.LoaderId loaderId, org.openqa.selenium.devtools.v112.page.model.FrameId frameId, java.util.List<org.openqa.selenium.devtools.v112.page.model.BackForwardCacheNotRestoredExplanation> notRestoredExplanations, java.util.Optional<org.openqa.selenium.devtools.v112.page.model.BackForwardCacheNotRestoredExplanationTree> notRestoredExplanationsTree) {
        this.loaderId = java.util.Objects.requireNonNull(loaderId, "loaderId is required");
        this.frameId = java.util.Objects.requireNonNull(frameId, "frameId is required");
        this.notRestoredExplanations = java.util.Objects.requireNonNull(notRestoredExplanations, "notRestoredExplanations is required");
        this.notRestoredExplanationsTree = notRestoredExplanationsTree;
    }

    /**
     * The loader id for the associated navgation.
     */
    public org.openqa.selenium.devtools.v112.network.model.LoaderId getLoaderId() {
        return loaderId;
    }

    /**
     * The frame id of the associated frame.
     */
    public org.openqa.selenium.devtools.v112.page.model.FrameId getFrameId() {
        return frameId;
    }

    /**
     * Array of reasons why the page could not be cached. This must not be empty.
     */
    public java.util.List<org.openqa.selenium.devtools.v112.page.model.BackForwardCacheNotRestoredExplanation> getNotRestoredExplanations() {
        return notRestoredExplanations;
    }

    /**
     * Tree structure of reasons why the page could not be cached for each frame.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v112.page.model.BackForwardCacheNotRestoredExplanationTree> getNotRestoredExplanationsTree() {
        return notRestoredExplanationsTree;
    }

    private static BackForwardCacheNotUsed fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v112.network.model.LoaderId loaderId = null;
        org.openqa.selenium.devtools.v112.page.model.FrameId frameId = null;
        java.util.List<org.openqa.selenium.devtools.v112.page.model.BackForwardCacheNotRestoredExplanation> notRestoredExplanations = null;
        java.util.Optional<org.openqa.selenium.devtools.v112.page.model.BackForwardCacheNotRestoredExplanationTree> notRestoredExplanationsTree = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "loaderId":
                    loaderId = input.read(org.openqa.selenium.devtools.v112.network.model.LoaderId.class);
                    break;
                case "frameId":
                    frameId = input.read(org.openqa.selenium.devtools.v112.page.model.FrameId.class);
                    break;
                case "notRestoredExplanations":
                    notRestoredExplanations = input.read(new com.google.common.reflect.TypeToken<java.util.List<org.openqa.selenium.devtools.v112.page.model.BackForwardCacheNotRestoredExplanation>>() {
                    }.getType());
                    break;
                case "notRestoredExplanationsTree":
                    notRestoredExplanationsTree = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v112.page.model.BackForwardCacheNotRestoredExplanationTree.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new BackForwardCacheNotUsed(loaderId, frameId, notRestoredExplanations, notRestoredExplanationsTree);
    }
}
