/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v108.network.model;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@Beta
public class SignedExchangeSignature {
    private final String label;
    private final String signature;
    private final String integrity;
    private final Optional<String> certUrl;
    private final Optional<String> certSha256;
    private final String validityUrl;
    private final Integer date;
    private final Integer expires;
    private final Optional<List<String>> certificates;

    public SignedExchangeSignature(String label, String signature, String integrity, Optional<String> certUrl, Optional<String> certSha256, String validityUrl, Integer date, Integer expires, Optional<List<String>> certificates) {
        this.label = Objects.requireNonNull(label, "label is required");
        this.signature = Objects.requireNonNull(signature, "signature is required");
        this.integrity = Objects.requireNonNull(integrity, "integrity is required");
        this.certUrl = certUrl;
        this.certSha256 = certSha256;
        this.validityUrl = Objects.requireNonNull(validityUrl, "validityUrl is required");
        this.date = Objects.requireNonNull(date, "date is required");
        this.expires = Objects.requireNonNull(expires, "expires is required");
        this.certificates = certificates;
    }

    public String getLabel() {
        return this.label;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getIntegrity() {
        return this.integrity;
    }

    public Optional<String> getCertUrl() {
        return this.certUrl;
    }

    public Optional<String> getCertSha256() {
        return this.certSha256;
    }

    public String getValidityUrl() {
        return this.validityUrl;
    }

    public Integer getDate() {
        return this.date;
    }

    public Integer getExpires() {
        return this.expires;
    }

    public Optional<List<String>> getCertificates() {
        return this.certificates;
    }

    private static SignedExchangeSignature fromJson(JsonInput input) {
        String label = null;
        String signature = null;
        String integrity = null;
        Optional<String> certUrl = Optional.empty();
        Optional<String> certSha256 = Optional.empty();
        String validityUrl = null;
        Integer date = 0;
        Integer expires = 0;
        Optional<List<String>> certificates = Optional.empty();
        input.beginObject();
        block22: while (input.hasNext()) {
            switch (input.nextName()) {
                case "label": {
                    label = input.nextString();
                    continue block22;
                }
                case "signature": {
                    signature = input.nextString();
                    continue block22;
                }
                case "integrity": {
                    integrity = input.nextString();
                    continue block22;
                }
                case "certUrl": {
                    certUrl = Optional.ofNullable(input.nextString());
                    continue block22;
                }
                case "certSha256": {
                    certSha256 = Optional.ofNullable(input.nextString());
                    continue block22;
                }
                case "validityUrl": {
                    validityUrl = input.nextString();
                    continue block22;
                }
                case "date": {
                    date = input.nextNumber().intValue();
                    continue block22;
                }
                case "expires": {
                    expires = input.nextNumber().intValue();
                    continue block22;
                }
                case "certificates": {
                    certificates = Optional.ofNullable((List)input.read(new TypeToken<List<String>>(){}.getType()));
                    continue block22;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new SignedExchangeSignature(label, signature, integrity, certUrl, certSha256, validityUrl, date, expires, certificates);
    }
}

