/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.SharedCapabilitiesMethods;
import org.openqa.selenium.internal.Require;

public class ImmutableCapabilities
implements Capabilities {
    private final Map<String, Object> delegate;

    public ImmutableCapabilities() {
        this.delegate = Collections.emptyMap();
    }

    public ImmutableCapabilities(String k, Object v) {
        Require.nonNull("Capability", k);
        Require.nonNull("Value", v);
        TreeMap<String, Object> delegate = new TreeMap<String, Object>();
        SharedCapabilitiesMethods.setCapability(delegate, k, v);
        this.delegate = Collections.unmodifiableMap(delegate);
    }

    public ImmutableCapabilities(String k1, Object v1, String k2, Object v2) {
        Require.nonNull("First capability", k1);
        Require.nonNull("First value", v1);
        Require.nonNull("Second capability", k2);
        Require.nonNull("Second value", v2);
        TreeMap<String, Object> delegate = new TreeMap<String, Object>();
        SharedCapabilitiesMethods.setCapability(delegate, k1, v1);
        SharedCapabilitiesMethods.setCapability(delegate, k2, v2);
        this.delegate = Collections.unmodifiableMap(delegate);
    }

    public ImmutableCapabilities(String k1, Object v1, String k2, Object v2, String k3, Object v3) {
        Require.nonNull("First capability", k1);
        Require.nonNull("First value", v1);
        Require.nonNull("Second capability", k2);
        Require.nonNull("Second value", v2);
        Require.nonNull("Third capability", k3);
        Require.nonNull("Third value", v3);
        TreeMap<String, Object> delegate = new TreeMap<String, Object>();
        SharedCapabilitiesMethods.setCapability(delegate, k1, v1);
        SharedCapabilitiesMethods.setCapability(delegate, k2, v2);
        SharedCapabilitiesMethods.setCapability(delegate, k3, v3);
        this.delegate = Collections.unmodifiableMap(delegate);
    }

    public ImmutableCapabilities(String k1, Object v1, String k2, Object v2, String k3, Object v3, String k4, Object v4) {
        Require.nonNull("First capability", k1);
        Require.nonNull("First value", v1);
        Require.nonNull("Second capability", k2);
        Require.nonNull("Second value", v2);
        Require.nonNull("Third capability", k3);
        Require.nonNull("Third value", v3);
        Require.nonNull("Fourth capability", k4);
        Require.nonNull("Fourth value", v4);
        TreeMap<String, Object> delegate = new TreeMap<String, Object>();
        SharedCapabilitiesMethods.setCapability(delegate, k1, v1);
        SharedCapabilitiesMethods.setCapability(delegate, k2, v2);
        SharedCapabilitiesMethods.setCapability(delegate, k3, v3);
        SharedCapabilitiesMethods.setCapability(delegate, k4, v4);
        this.delegate = Collections.unmodifiableMap(delegate);
    }

    public ImmutableCapabilities(String k1, Object v1, String k2, Object v2, String k3, Object v3, String k4, Object v4, String k5, Object v5) {
        Require.nonNull("First capability", k1);
        Require.nonNull("First value", v1);
        Require.nonNull("Second capability", k2);
        Require.nonNull("Second value", v2);
        Require.nonNull("Third capability", k3);
        Require.nonNull("Third value", v3);
        Require.nonNull("Fourth capability", k4);
        Require.nonNull("Fourth value", v4);
        Require.nonNull("Fifth capability", k5);
        Require.nonNull("Fifth value", v5);
        TreeMap<String, Object> delegate = new TreeMap<String, Object>();
        SharedCapabilitiesMethods.setCapability(delegate, k1, v1);
        SharedCapabilitiesMethods.setCapability(delegate, k2, v2);
        SharedCapabilitiesMethods.setCapability(delegate, k3, v3);
        SharedCapabilitiesMethods.setCapability(delegate, k4, v4);
        SharedCapabilitiesMethods.setCapability(delegate, k5, v5);
        this.delegate = Collections.unmodifiableMap(delegate);
    }

    public ImmutableCapabilities(Capabilities other) {
        Require.nonNull("Capabilities", other);
        TreeMap delegate = new TreeMap();
        other.getCapabilityNames().forEach(name -> {
            Require.nonNull("Capability name", name);
            Object value = other.getCapability((String)name);
            Require.nonNull("Capability value", value);
            SharedCapabilitiesMethods.setCapability(delegate, name, value);
        });
        this.delegate = Collections.unmodifiableMap(delegate);
    }

    public ImmutableCapabilities(Map<?, ?> capabilities) {
        Require.nonNull("Capabilities", capabilities);
        TreeMap delegate = new TreeMap();
        capabilities.forEach((key, value) -> {
            Require.argument("Capability key", key).instanceOf(String.class);
            Object v = capabilities.get(key);
            Require.nonNull("Capability value", value);
            SharedCapabilitiesMethods.setCapability(delegate, (String)key, v);
        });
        this.delegate = Collections.unmodifiableMap(delegate);
    }

    @Override
    public Object getCapability(String capabilityName) {
        Require.nonNull("Capability name", capabilityName);
        return this.delegate.get(capabilityName);
    }

    @Override
    public Map<String, Object> asMap() {
        return this.delegate;
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Capabilities)) {
            return false;
        }
        Capabilities other = (Capabilities)o;
        Set<String> names = other.getCapabilityNames();
        if (names.size() != this.delegate.size()) {
            return false;
        }
        for (String name : names) {
            if (Objects.equals(this.delegate.get(name), other.getCapability(name))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return SharedCapabilitiesMethods.toString(this.delegate);
    }

    public static ImmutableCapabilities copyOf(Capabilities capabilities) {
        Require.nonNull("Capabilities", capabilities);
        if (capabilities instanceof ImmutableCapabilities) {
            return (ImmutableCapabilities)capabilities;
        }
        return new ImmutableCapabilities(capabilities);
    }
}

