/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.htmlunit.options;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.security.KeyStore;
import java.util.Map;
import org.htmlunit.BrowserVersion;
import org.htmlunit.ProxyConfig;
import org.htmlunit.WebClientOptions;
import org.openqa.selenium.htmlunit.options.HtmlUnitOptionNames;
import org.openqa.selenium.htmlunit.options.KeyStoreBean;
import org.openqa.selenium.htmlunit.options.OptionEnum;
import org.openqa.selenium.htmlunit.options.TypeCodec;

public enum HtmlUnitOption implements HtmlUnitOptionNames,
OptionEnum
{
    WEB_CLIENT_VERSION("webClientVersion", BrowserVersion.class, BrowserVersion.BEST_SUPPORTED),
    JAVASCRIPT_ENABLED("javascriptEnabled", (Class)Boolean.TYPE, (Object)true){

        @Override
        public void insert(WebClientOptions options, Object value) {
            options.setJavaScriptEnabled(TypeCodec.decodeBoolean(value));
        }

        @Override
        public Object obtain(WebClientOptions options) {
            return options.isJavaScriptEnabled();
        }
    }
    ,
    CSS_ENABLED("cssEnabled", (Class)Boolean.TYPE, (Object)true){

        @Override
        public void insert(WebClientOptions options, Object value) {
            options.setCssEnabled(TypeCodec.decodeBoolean(value));
        }

        @Override
        public Object obtain(WebClientOptions options) {
            return options.isCssEnabled();
        }
    }
    ,
    PRINT_CONTENT_ON_FAILING_STATUS_CODE("printContentOnFailingStatusCode", (Class)Boolean.TYPE, (Object)true){

        @Override
        public void insert(WebClientOptions options, Object value) {
            options.setPrintContentOnFailingStatusCode(TypeCodec.decodeBoolean(value));
        }

        @Override
        public Object obtain(WebClientOptions options) {
            return options.isPrintContentOnFailingStatusCode();
        }
    }
    ,
    THROW_EXCEPTION_ON_FAILING_STATUS_CODE("throwExceptionOnFailingStatusCode", (Class)Boolean.TYPE, (Object)true){

        @Override
        public void insert(WebClientOptions options, Object value) {
            options.setThrowExceptionOnFailingStatusCode(TypeCodec.decodeBoolean(value));
        }

        @Override
        public Object obtain(WebClientOptions options) {
            return options.isThrowExceptionOnFailingStatusCode();
        }
    }
    ,
    THROW_EXCEPTION_ON_SCRIPT_ERROR("throwExceptionOnScriptError", (Class)Boolean.TYPE, (Object)true){

        @Override
        public void insert(WebClientOptions options, Object value) {
            options.setThrowExceptionOnScriptError(TypeCodec.decodeBoolean(value));
        }

        @Override
        public Object obtain(WebClientOptions options) {
            return options.isThrowExceptionOnScriptError();
        }
    }
    ,
    POPUP_BLOCKER_ENABLED("popupBlockerEnabled", (Class)Boolean.TYPE, (Object)false){

        @Override
        public void insert(WebClientOptions options, Object value) {
            options.setPopupBlockerEnabled(TypeCodec.decodeBoolean(value));
        }

        @Override
        public Object obtain(WebClientOptions options) {
            return options.isPopupBlockerEnabled();
        }
    }
    ,
    IS_REDIRECT_ENABLED("isRedirectEnabled", (Class)Boolean.TYPE, (Object)true){

        @Override
        public void insert(WebClientOptions options, Object value) {
            options.setRedirectEnabled(TypeCodec.decodeBoolean(value));
        }

        @Override
        public Object obtain(WebClientOptions options) {
            return options.isRedirectEnabled();
        }
    }
    ,
    TEMP_FILE_DIRECTORY("tempFileDirectory", (Class)File.class, (Object)null){

        @Override
        public void insert(WebClientOptions options, Object value) {
            try {
                options.setTempFileDirectory(TypeCodec.decodeFile(value));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed setting directory for temporary files", e);
            }
        }

        @Override
        public Object obtain(WebClientOptions options) {
            return options.getTempFileDirectory();
        }
    }
    ,
    SSL_CLIENT_CERTIFICATE_STORE("sslClientCertificateStore", (Class)KeyStore.class, (Object)null){

        @Override
        public Object encode(Object value) {
            return null;
        }

        @Override
        public void insert(WebClientOptions options, Object value) {
            try {
                KeyStoreBean bean = TypeCodec.decodeKeyStore(value);
                options.setSSLClientCertificateKeyStore(bean.createUrl(), bean.getPassword(), bean.getType());
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Specified SSL_CLIENT_CERTIFICATE_STORE URL is malformed", e);
            }
        }

        @Override
        public Object obtain(WebClientOptions options) {
            return options.getSSLClientCertificateStore();
        }
    }
    ,
    SSL_CLIENT_CERTIFICATE_TYPE("sslClientCertificateType", (Class)char[].class, (Object)null){

        @Override
        public void insert(WebClientOptions options, Object value) {
            if (!this.isDefaultValue(value)) {
                throw new UnsupportedOperationException("SSL client certificate key store type cannot be set as a discrete value; use HtmlUnitDriverOptions.setSSLClientCertificateStore() instead");
            }
        }

        @Override
        public Object obtain(WebClientOptions options) {
            KeyStore keyStore = options.getSSLClientCertificateStore();
            return keyStore != null ? keyStore.getType() : null;
        }
    }
    ,
    SSL_CLIENT_CERTIFICATE_PASSWORD("sslClientCertificatePassword", (Class)char[].class, (Object)null){

        @Override
        public void insert(WebClientOptions options, Object value) {
            if (!this.isDefaultValue(value)) {
                throw new UnsupportedOperationException("SSL client certificate key store password cannot be set as a discrete value; use HtmlUnitDriverOptions.setSSLClientCertificateStore() instead");
            }
        }

        @Override
        public Object obtain(WebClientOptions options) {
            return options.getSSLClientCertificatePassword();
        }
    }
    ,
    SSL_TRUST_STORE("sslTrustStore", (Class)KeyStore.class, (Object)null){

        @Override
        public Object encode(Object value) {
            return null;
        }

        @Override
        public void insert(WebClientOptions options, Object value) {
            try {
                KeyStoreBean bean = TypeCodec.decodeKeyStore(value);
                options.setSSLTrustStore(bean.createUrl(), bean.getPassword(), bean.getType());
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Specified SSL_TRUST_STORE URL is malformed", e);
            }
        }

        @Override
        public Object obtain(WebClientOptions options) {
            return options.getSSLTrustStore();
        }
    }
    ,
    SSL_TRUST_STORE_TYPE("sslTrustStoreType", (Class)char[].class, (Object)null){

        @Override
        public void insert(WebClientOptions options, Object value) {
            if (!this.isDefaultValue(value)) {
                throw new UnsupportedOperationException("SSL trust key store type cannot be set as a discrete value; use HtmlUnitDriverOptions.setSSLTrustStore() instead");
            }
        }

        @Override
        public Object obtain(WebClientOptions options) {
            KeyStore keyStore = options.getSSLTrustStore();
            return keyStore != null ? keyStore.getType() : null;
        }
    }
    ,
    SSL_TRUST_STORE_PASSWORD("sslTrustStorePassword", (Class)char[].class, (Object)null){

        @Override
        public void insert(WebClientOptions options, Object value) {
            if (!this.isDefaultValue(value)) {
                throw new UnsupportedOperationException("SSL trust key store password cannot be set as a discrete value; use HtmlUnitDriverOptions.setSSLTrustStore() instead");
            }
        }

        @Override
        public Object obtain(WebClientOptions options) {
            throw new UnsupportedOperationException("SSL trust store password cannot be retrieved");
        }
    }
    ,
    SSL_CLIENT_PROTOCOLS("sslClientProtocols", (Class)String[].class, (Object)null){

        @Override
        public void insert(WebClientOptions options, Object value) {
            options.setSSLClientProtocols(TypeCodec.decodeStringArray(value));
        }

        @Override
        public Object obtain(WebClientOptions options) {
            return options.getSSLClientProtocols();
        }
    }
    ,
    SSL_CLIENT_CIPHER_SUITES("sslClientCipherSuites", (Class)String[].class, (Object)null){

        @Override
        public void insert(WebClientOptions options, Object value) {
            options.setSSLClientCipherSuites(TypeCodec.decodeStringArray(value));
        }

        @Override
        public Object obtain(WebClientOptions options) {
            return options.getSSLClientCipherSuites();
        }
    }
    ,
    GEOLOCATION_ENABLED("geolocationEnabled", (Class)Boolean.TYPE, (Object)false){

        @Override
        public void insert(WebClientOptions options, Object value) {
            options.setGeolocationEnabled(TypeCodec.decodeBoolean(value));
        }

        @Override
        public Object obtain(WebClientOptions options) {
            return options.isGeolocationEnabled();
        }
    }
    ,
    DO_NOT_TRACK_ENABLED("doNotTrackEnabled", (Class)Boolean.TYPE, (Object)false){

        @Override
        public void insert(WebClientOptions options, Object value) {
            options.setDoNotTrackEnabled(TypeCodec.decodeBoolean(value));
        }

        @Override
        public Object obtain(WebClientOptions options) {
            return options.isDoNotTrackEnabled();
        }
    }
    ,
    HOME_PAGE("homePage", (Class)String.class, (Object)"https://www.htmlunit.org/"){

        @Override
        public void insert(WebClientOptions options, Object value) {
            options.setHomePage(TypeCodec.decodeString(value));
        }

        @Override
        public Object obtain(WebClientOptions options) {
            return options.getHomePage();
        }
    }
    ,
    PROXY_CONFIG("proxyConfig", (Class)ProxyConfig.class, (Object)null){

        @Override
        public void insert(WebClientOptions options, Object value) {
            options.setProxyConfig(TypeCodec.decodeProxyConfig(value));
        }

        @Override
        public Object obtain(WebClientOptions options) {
            return options.getProxyConfig();
        }
    }
    ,
    TIMEOUT("timeout", (Class)Integer.TYPE, (Object)90000){

        @Override
        public void insert(WebClientOptions options, Object value) {
            options.setTimeout(TypeCodec.decodeInt(value));
        }

        @Override
        public Object obtain(WebClientOptions options) {
            return options.getTimeout();
        }
    }
    ,
    CONNECTION_TIME_TO_LIVE("connectionTimeToLive", (Class)Long.TYPE, (Object)-1L){

        @Override
        public void insert(WebClientOptions options, Object value) {
            options.setConnectionTimeToLive(TypeCodec.decodeLong(value));
        }

        @Override
        public Object obtain(WebClientOptions options) {
            return options.getConnectionTimeToLive();
        }
    }
    ,
    USE_INSECURE_SSL("useInsecureSSL", (Class)Boolean.TYPE, (Object)false){

        @Override
        public void insert(WebClientOptions options, Object value) {
            options.setUseInsecureSSL(TypeCodec.decodeBoolean(value));
        }

        @Override
        public Object obtain(WebClientOptions options) {
            return options.isUseInsecureSSL();
        }
    }
    ,
    SSL_INSECURE_PROTOCOL("sslInsecureProtocol", (Class)String.class, (Object)null){

        @Override
        public void insert(WebClientOptions options, Object value) {
            options.setSSLInsecureProtocol(TypeCodec.decodeString(value));
        }

        @Override
        public Object obtain(WebClientOptions options) {
            return options.getSSLInsecureProtocol();
        }
    }
    ,
    MAX_IN_MEMORY("maxInMemory", (Class)Integer.TYPE, (Object)512000){

        @Override
        public void insert(WebClientOptions options, Object value) {
            options.setMaxInMemory(TypeCodec.decodeInt(value));
        }

        @Override
        public Object obtain(WebClientOptions options) {
            return options.getMaxInMemory();
        }
    }
    ,
    HISTORY_SIZE_LIMIT("historySizeLimit", (Class)Integer.TYPE, (Object)50){

        @Override
        public void insert(WebClientOptions options, Object value) {
            options.setHistorySizeLimit(TypeCodec.decodeInt(value));
        }

        @Override
        public Object obtain(WebClientOptions options) {
            return options.getHistorySizeLimit();
        }
    }
    ,
    HISTORY_PAGE_CACHE_LIMIT("historyPageCacheLimit", (Class)Integer.TYPE, (Object)Integer.MAX_VALUE){

        @Override
        public void insert(WebClientOptions options, Object value) {
            options.setHistoryPageCacheLimit(TypeCodec.decodeInt(value));
        }

        @Override
        public Object obtain(WebClientOptions options) {
            return options.getHistoryPageCacheLimit();
        }
    }
    ,
    LOCAL_ADDRESS("localAddress", (Class)InetAddress.class, (Object)null){

        @Override
        public void insert(WebClientOptions options, Object value) {
            options.setLocalAddress(TypeCodec.decodeInetAddress(value));
        }

        @Override
        public Object obtain(WebClientOptions options) {
            return options.getLocalAddress();
        }
    }
    ,
    DOWNLOAD_IMAGES("downloadImages", (Class)Boolean.TYPE, (Object)false){

        @Override
        public void insert(WebClientOptions options, Object value) {
            options.setDownloadImages(TypeCodec.decodeBoolean(value));
        }

        @Override
        public Object obtain(WebClientOptions options) {
            return options.isDownloadImages();
        }
    }
    ,
    SCREEN_WIDTH("screenWidth", (Class)Integer.TYPE, (Object)1920){

        @Override
        public void insert(WebClientOptions options, Object value) {
            options.setScreenWidth(TypeCodec.decodeInt(value));
        }

        @Override
        public Object obtain(WebClientOptions options) {
            return options.getScreenWidth();
        }
    }
    ,
    SCREEN_HEIGHT("screenHeight", (Class)Integer.TYPE, (Object)1080){

        @Override
        public void insert(WebClientOptions options, Object value) {
            options.setScreenHeight(TypeCodec.decodeInt(value));
        }

        @Override
        public Object obtain(WebClientOptions options) {
            return options.getScreenHeight();
        }
    }
    ,
    WEB_SOCKET_ENABLED("webSocketEnabled", (Class)Boolean.TYPE, (Object)true){

        @Override
        public void insert(WebClientOptions options, Object value) {
            options.setWebSocketEnabled(TypeCodec.decodeBoolean(value));
        }

        @Override
        public Object obtain(WebClientOptions options) {
            return options.isWebSocketEnabled();
        }
    }
    ,
    WEB_SOCKET_MAX_TEXT_MESSAGE_SIZE("webSocketMaxTextMessageSize", (Class)Integer.TYPE, (Object)-1){

        @Override
        public void insert(WebClientOptions options, Object value) {
            options.setWebSocketMaxTextMessageSize(TypeCodec.decodeInt(value));
        }

        @Override
        public Object obtain(WebClientOptions options) {
            return options.getWebSocketMaxTextMessageSize();
        }
    }
    ,
    WEB_SOCKET_MAX_TEXT_MESSAGE_BUFFER_SIZE("webSocketMaxTextMessageBufferSize", (Class)Integer.TYPE, (Object)-1){

        @Override
        public void insert(WebClientOptions options, Object value) {
            options.setWebSocketMaxTextMessageBufferSize(TypeCodec.decodeInt(value));
        }

        @Override
        public Object obtain(WebClientOptions options) {
            return options.getWebSocketMaxTextMessageBufferSize();
        }
    }
    ,
    WEB_SOCKET_MAX_BINARY_MESSAGE_SIZE("webSocketMaxBinaryMessageSize", (Class)Integer.TYPE, (Object)-1){

        @Override
        public void insert(WebClientOptions options, Object value) {
            options.setWebSocketMaxBinaryMessageSize(TypeCodec.decodeInt(value));
        }

        @Override
        public Object obtain(WebClientOptions options) {
            return options.getWebSocketMaxBinaryMessageSize();
        }
    }
    ,
    WEB_SOCKET_MAX_BINARY_MESSAGE_BUFFER_SIZE("webSocketMaxBinaryMessageBufferSize", (Class)Integer.TYPE, (Object)-1){

        @Override
        public void insert(WebClientOptions options, Object value) {
            options.setWebSocketMaxBinaryMessageBufferSize(TypeCodec.decodeInt(value));
        }

        @Override
        public Object obtain(WebClientOptions options) {
            return options.getWebSocketMaxBinaryMessageBufferSize();
        }
    }
    ,
    FETCH_POLYFILL_ENABLED("fetchPolyfillEnabled", (Class)Boolean.TYPE, (Object)false){

        @Override
        public void insert(WebClientOptions options, Object value) {
            options.setFetchPolyfillEnabled(TypeCodec.decodeBoolean(value));
        }

        @Override
        public Object obtain(WebClientOptions options) {
            return options.isFetchPolyfillEnabled();
        }
    }
    ,
    FILE_PROTOCOL_FOR_XMLHTTPREQUESTS_ALLOWED("fileProtocolForXMLHttpRequestsAllowed", (Class)Boolean.TYPE, (Object)false){

        @Override
        public void insert(WebClientOptions options, Object value) {
            options.setFileProtocolForXMLHttpRequestsAllowed(TypeCodec.decodeBoolean(value));
        }

        @Override
        public Object obtain(WebClientOptions options) {
            return options.isFileProtocolForXMLHttpRequestsAllowed();
        }
    };

    private final String capabilityKey_;
    private final String propertyName_;
    private final Class<?> optionType_;
    private final Object defaultValue_;

    private HtmlUnitOption(String key, Class<?> type, Object initial) {
        this.capabilityKey_ = key;
        this.propertyName_ = "webdriver.htmlunit." + key;
        this.optionType_ = type;
        this.defaultValue_ = initial;
    }

    @Override
    public String getCapabilityKey() {
        return this.capabilityKey_;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName_;
    }

    @Override
    public Class<?> getOptionType() {
        return this.optionType_;
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue_;
    }

    @Override
    public boolean isDefaultValue(Object value) {
        if (this.defaultValue_ == null) {
            return value == null;
        }
        if (value == null) {
            return false;
        }
        return value.equals(this.defaultValue_);
    }

    @Override
    public void applyPropertyTo(Map<String, Object> optionsMap) {
        String value = System.getProperty(this.propertyName_);
        if (value != null) {
            optionsMap.put(this.capabilityKey_, this.decode(value));
            System.clearProperty(this.capabilityKey_);
        }
    }

    @Override
    public Object encode(Object value) {
        switch (this.optionType_.getName()) {
            case "boolean": 
            case "int": 
            case "long": 
            case "java.lang.String": 
            case "[C": 
            case "[Ljava.lang.String;": {
                return value;
            }
            case "java.io.File": {
                return TypeCodec.encodeFile(value);
            }
            case "java.net.InetAddress": {
                return TypeCodec.encodeInetAddress(value);
            }
            case "org.htmlunit.ProxyConfig": {
                return TypeCodec.encodeProxyConfig(value);
            }
            case "org.htmlunit.BrowserVersion": {
                return TypeCodec.encodeBrowserVersion(value);
            }
        }
        throw new IllegalStateException(String.format("Unsupported type '%s' specified for option [%s]; value is of type: %s", this.optionType_.getName(), this.toString(), TypeCodec.getClassName(value)));
    }

    @Override
    public Object decode(Object value) {
        switch (this.optionType_.getName()) {
            case "boolean": {
                return TypeCodec.decodeBoolean(value);
            }
            case "int": {
                return TypeCodec.decodeInt(value);
            }
            case "long": {
                return TypeCodec.decodeLong(value);
            }
            case "java.lang.String": {
                return TypeCodec.decodeString(value);
            }
            case "[C": {
                return TypeCodec.decodeCharArray(value);
            }
            case "[Ljava.lang.String;": {
                return TypeCodec.decodeStringArray(value);
            }
            case "java.io.File": {
                return TypeCodec.decodeFile(value);
            }
            case "java.net.InetAddress": {
                return TypeCodec.decodeInetAddress(value);
            }
            case "java.security.KeyStore": {
                return TypeCodec.decodeKeyStore(value);
            }
            case "org.htmlunit.ProxyConfig": {
                return TypeCodec.decodeProxyConfig(value);
            }
            case "org.htmlunit.BrowserVersion": {
                return TypeCodec.decodeBrowserVersion(value);
            }
        }
        throw new IllegalStateException(String.format("Unsupported type '%s' specified for option [%s]; value is of type: %s", this.optionType_.getName(), this.toString(), TypeCodec.getClassName(value)));
    }

    public void insert(WebClientOptions options, Object value) {
        throw new UnsupportedOperationException(String.format("Option '%s' does not support value insertion", this.toString()));
    }

    public Object obtain(WebClientOptions options) {
        return null;
    }

    public static HtmlUnitOption fromCapabilityKey(String key) {
        for (HtmlUnitOption option : HtmlUnitOption.values()) {
            if (!option.capabilityKey_.equals(key)) continue;
            return option;
        }
        return null;
    }

    public static HtmlUnitOption fromPropertyName(String name) {
        for (HtmlUnitOption option : HtmlUnitOption.values()) {
            if (!option.propertyName_.equals(name)) continue;
            return option;
        }
        return null;
    }
}

